/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http.handlers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.component.netty.http.ContextPathMatcher;
import org.apache.camel.component.netty.http.DefaultContextPathMatcher;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.apache.camel.component.netty.http.handlers.HttpServerChannelHandler;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerMultiplexChannelHandler
extends SimpleChannelUpstreamHandler
implements HttpServerConsumerChannelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpConsumer.class);
    private final ConcurrentMap<ContextPathMatcher, HttpServerChannelHandler> consumers = new ConcurrentHashMap<ContextPathMatcher, HttpServerChannelHandler>();
    private int port;
    private String token;
    private int len;

    @Override
    public void init(int port) {
        this.port = port;
        this.token = ":" + port;
        this.len = this.token.length();
    }

    @Override
    public void addConsumer(NettyHttpConsumer consumer) {
        String path = HttpServerMultiplexChannelHandler.pathAsKey(consumer.getConfiguration().getPath());
        DefaultContextPathMatcher matcher = new DefaultContextPathMatcher(path, consumer.getConfiguration().isMatchOnUriPrefix());
        this.consumers.put(matcher, new HttpServerChannelHandler(consumer));
    }

    @Override
    public void removeConsumer(NettyHttpConsumer consumer) {
        String path = HttpServerMultiplexChannelHandler.pathAsKey(consumer.getConfiguration().getPath());
        DefaultContextPathMatcher matcher = new DefaultContextPathMatcher(path, consumer.getConfiguration().isMatchOnUriPrefix());
        this.consumers.remove(matcher);
    }

    @Override
    public int consumers() {
        return this.consumers.size();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        HttpRequest request = (HttpRequest)messageEvent.getMessage();
        LOG.debug("Message received: {}", (Object)request);
        HttpServerChannelHandler handler = this.getHandler(request);
        if (handler != null) {
            ctx.setAttachment((Object)handler);
            handler.messageReceived(ctx, messageEvent);
        } else {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.setHeader("Content-Type", (Object)"text/plain");
            response.setHeader("Content-Length", (Object)0);
            response.setContent(ChannelBuffers.copiedBuffer((byte[])new byte[0]));
            messageEvent.getChannel().write((Object)response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        HttpServerChannelHandler handler = (HttpServerChannelHandler)((Object)ctx.getAttachment());
        if (handler != null) {
            handler.exceptionCaught(ctx, e);
        } else {
            LOG.warn("HttpServerChannelHandler is not found as attachment to handle exception, send 404 back to the client.", e.getCause());
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            response.setContent(ChannelBuffers.copiedBuffer((byte[])new byte[0]));
            ctx.getChannel().write((Object)response);
        }
    }

    private HttpServerChannelHandler getHandler(HttpRequest request) {
        String path = request.getUri();
        int idx = path.indexOf(this.token);
        if (idx > -1) {
            path = path.substring(idx + this.len);
        }
        path = HttpServerMultiplexChannelHandler.pathAsKey(path);
        for (Map.Entry entry : this.consumers.entrySet()) {
            if (!((ContextPathMatcher)entry.getKey()).matches(path)) continue;
            return (HttpServerChannelHandler)((Object)entry.getValue());
        }
        return null;
    }

    private static String pathAsKey(String path) {
        int idx;
        if (path == null || path.equals("/")) {
            path = "";
        }
        if ((idx = path.indexOf(63)) > -1) {
            path = path.substring(0, idx);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return UnsafeUriCharactersEncoder.encodeHttpURI((String)path);
    }
}

