/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.util.Locale;
import org.apache.camel.component.netty.http.ContextPathMatcher;

public class DefaultContextPathMatcher
implements ContextPathMatcher {
    private final String path;
    private final boolean matchOnUriPrefix;

    public DefaultContextPathMatcher(String path, boolean matchOnUriPrefix) {
        this.path = path.toLowerCase(Locale.US);
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    @Override
    public boolean matches(String target) {
        target = target.toLowerCase(Locale.US);
        if (!this.matchOnUriPrefix) {
            return target.equals(this.path);
        }
        return target.startsWith(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultContextPathMatcher that = (DefaultContextPathMatcher)o;
        if (this.matchOnUriPrefix != that.matchOnUriPrefix) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (this.matchOnUriPrefix ? 1 : 0);
        return result;
    }
}

