/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.HttpServerPipelineFactory;
import org.apache.camel.component.netty.http.NettySharedHttpServerBootstrapConfiguration;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerSharedPipelineFactory
extends HttpServerPipelineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerSharedPipelineFactory.class);
    private final NettySharedHttpServerBootstrapConfiguration configuration;
    private final HttpServerConsumerChannelFactory channelFactory;
    private final ClassResolver classResolver;
    private SSLContext sslContext;

    public HttpServerSharedPipelineFactory(NettySharedHttpServerBootstrapConfiguration configuration, HttpServerConsumerChannelFactory channelFactory, ClassResolver classResolver) {
        this.configuration = configuration;
        this.channelFactory = channelFactory;
        this.classResolver = classResolver != null ? classResolver : new DefaultClassResolver();
        try {
            this.sslContext = this.createSSLContext();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    @Override
    public ServerPipelineFactory createPipelineFactory(NettyConsumer nettyConsumer) {
        throw new UnsupportedOperationException("Should not call this operation");
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            LOG.debug("Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        if (this.configuration.isChunked()) {
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.configuration.getChunkedMaxContentLength()));
        }
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (this.configuration.isCompression()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        }
        pipeline.addLast("handler", this.channelFactory.getChannelHandler());
        return pipeline;
    }

    private SSLContext createSSLContext() throws Exception {
        SSLContext answer;
        if (!this.configuration.isSsl()) {
            return null;
        }
        if (this.configuration.getSslContextParameters() != null) {
            answer = this.configuration.getSslContextParameters().createSSLContext();
        } else {
            if (this.configuration.getKeyStoreFile() == null && this.configuration.getKeyStoreResource() == null) {
                LOG.debug("keystorefile is null");
            }
            if (this.configuration.getTrustStoreFile() == null && this.configuration.getTrustStoreResource() == null) {
                LOG.debug("truststorefile is null");
            }
            if (this.configuration.getPassphrase().toCharArray() == null) {
                LOG.debug("passphrase is null");
            }
            if (this.configuration.getKeyStoreFile() != null || this.configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(this.classResolver, this.configuration.getKeyStoreFormat(), this.configuration.getSecurityProvider(), "file:" + this.configuration.getKeyStoreFile().getPath(), "file:" + this.configuration.getTrustStoreFile().getPath(), this.configuration.getPassphrase().toCharArray());
            } else {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(this.classResolver, this.configuration.getKeyStoreFormat(), this.configuration.getSecurityProvider(), this.configuration.getKeyStoreResource(), this.configuration.getTrustStoreResource(), this.configuration.getPassphrase().toCharArray());
            }
        }
        return answer;
    }

    private SslHandler configureServerSSLOnDemand() throws Exception {
        if (!this.configuration.isSsl()) {
            return null;
        }
        if (this.configuration.getSslHandler() != null) {
            return this.configuration.getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            engine.setNeedClientAuth(this.configuration.isNeedClientAuth());
            if (this.configuration.getSslContextParameters() == null) {
                engine.setEnabledProtocols(this.configuration.getEnabledProtocols().split(","));
            }
            return new SslHandler(engine);
        }
        return null;
    }
}

