/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.List;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.component.netty.handlers.ServerChannelHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerPipelineFactory
extends ServerPipelineFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultServerPipelineFactory.class);
    private final NettyConsumer consumer;

    public DefaultServerPipelineFactory(NettyConsumer consumer) {
        this.consumer = consumer;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline channelPipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand(this.consumer);
        if (sslHandler != null) {
            LOG.debug("Server SSL handler configured and added as an interceptor against the ChannelPipeline");
            this.addToPipeline("ssl", channelPipeline, (ChannelHandler)sslHandler);
        }
        List<ChannelHandler> encoders = this.consumer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            ChannelHandler encoder = encoders.get(x);
            if (encoder instanceof ChannelHandlerFactory) {
                encoder = ((ChannelHandlerFactory)encoder).newChannelHandler();
            }
            this.addToPipeline("encoder-" + x, channelPipeline, encoder);
        }
        List<ChannelHandler> decoders = this.consumer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            ChannelHandler decoder = decoders.get(x);
            if (decoder instanceof ChannelHandlerFactory) {
                decoder = ((ChannelHandlerFactory)decoder).newChannelHandler();
            }
            this.addToPipeline("decoder-" + x, channelPipeline, decoder);
        }
        if (this.consumer.getConfiguration().isOrderedThreadPoolExecutor()) {
            ExecutionHandler executionHandler = new ExecutionHandler((Executor)this.consumer.getEndpoint().getComponent().getExecutorService());
            this.addToPipeline("executionHandler", channelPipeline, (ChannelHandler)executionHandler);
            LOG.debug("Using OrderedMemoryAwareThreadPoolExecutor with core pool size: {}", (Object)this.consumer.getConfiguration().getMaximumPoolSize());
        }
        this.addToPipeline("handler", channelPipeline, (ChannelHandler)new ServerChannelHandler(this.consumer));
        LOG.trace("Created ChannelPipeline: {}", (Object)channelPipeline);
        return channelPipeline;
    }

    private void addToPipeline(String name, ChannelPipeline pipeline, ChannelHandler handler) {
        pipeline.addLast(name, handler);
    }

    private SslHandler configureServerSSLOnDemand(NettyConsumer consumer) throws Exception {
        if (!consumer.getConfiguration().isSsl()) {
            return null;
        }
        if (consumer.getConfiguration().getSslHandler() != null) {
            return consumer.getConfiguration().getSslHandler();
        }
        if (consumer.getConfiguration().getSslContextParameters() != null) {
            SSLContext context = consumer.getConfiguration().getSslContextParameters().createSSLContext();
            SSLEngine engine = context.createSSLEngine();
            engine.setUseClientMode(false);
            engine.setNeedClientAuth(consumer.getConfiguration().isNeedClientAuth());
            return new SslHandler(engine);
        }
        SSLEngineFactory sslEngineFactory = new SSLEngineFactory(consumer.getConfiguration().getKeyStoreFormat(), consumer.getConfiguration().getSecurityProvider(), consumer.getConfiguration().getKeyStoreFile(), consumer.getConfiguration().getTrustStoreFile(), consumer.getConfiguration().getPassphrase().toCharArray());
        SSLEngine sslEngine = sslEngineFactory.createServerSSLEngine();
        sslEngine.setUseClientMode(false);
        sslEngine.setNeedClientAuth(consumer.getConfiguration().isNeedClientAuth());
        return new SslHandler(sslEngine);
    }

    @Override
    public ServerPipelineFactory createPipelineFactory(NettyConsumer consumer) {
        return new DefaultServerPipelineFactory(consumer);
    }
}

