/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.DefaultClientPipelineFactory;
import org.apache.camel.component.netty.NettyCamelState;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyProducer
extends DefaultAsyncProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(NettyProducer.class);
    private static final ChannelGroup ALL_CHANNELS = new DefaultChannelGroup("NettyProducer");
    private CamelContext context;
    private NettyConfiguration configuration;
    private ChannelFactory channelFactory;
    private DatagramChannelFactory datagramChannelFactory;
    private ClientPipelineFactory pipelineFactory;
    private CamelLogger noReplyLogger;
    private ExecutorService bossExecutor;
    private ExecutorService workerExecutor;
    private ObjectPool<Channel> pool;

    public NettyProducer(NettyEndpoint nettyEndpoint, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint);
        this.configuration = configuration;
        this.context = this.getEndpoint().getCamelContext();
        this.noReplyLogger = new CamelLogger(LOG, configuration.getNoReplyLogLevel());
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    public boolean isSingleton() {
        return true;
    }

    public CamelContext getContext() {
        return this.context;
    }

    protected boolean isTcp() {
        return this.configuration.getProtocol().equalsIgnoreCase("tcp");
    }

    protected void doStart() throws Exception {
        super.doStart();
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.configuration.getProducerPoolMaxActive();
        config.minIdle = this.configuration.getProducerPoolMinIdle();
        config.maxIdle = this.configuration.getProducerPoolMaxIdle();
        config.testOnBorrow = true;
        config.testWhileIdle = true;
        config.timeBetweenEvictionRunsMillis = 30000L;
        config.minEvictableIdleTimeMillis = this.configuration.getProducerPoolMinEvictableIdle();
        config.whenExhaustedAction = 0;
        this.pool = new GenericObjectPool((PoolableObjectFactory)new NettyProducerPoolableObjectFactory(), config);
        ClientPipelineFactory factory = this.configuration.getClientPipelineFactory();
        this.pipelineFactory = factory != null ? factory.createPipelineFactory(this) : new DefaultClientPipelineFactory(this);
        if (this.isTcp()) {
            this.setupTCPCommunication();
        } else {
            this.setupUDPCommunication();
        }
        if (!this.configuration.isLazyChannelCreation()) {
            this.openAndCloseConnection();
        }
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping producer at address: {}", (Object)this.configuration.getAddress());
        LOG.trace("Closing {} channels", (Object)ALL_CHANNELS.size());
        ChannelGroupFuture future = ALL_CHANNELS.close();
        future.awaitUninterruptibly();
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
        if (this.bossExecutor != null) {
            this.context.getExecutorServiceManager().shutdownNow(this.bossExecutor);
        }
        if (this.workerExecutor != null) {
            this.context.getExecutorServiceManager().shutdownNow(this.workerExecutor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping producer with channel pool[active={}, idle={}]", (Object)this.pool.getNumActive(), (Object)this.pool.getNumIdle());
        }
        this.pool.close();
        super.doStop();
    }

    public boolean process(final Exchange exchange, AsyncCallback callback) {
        Channel existing;
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        Object body = NettyPayloadHelper.getIn(this.getEndpoint(), exchange);
        if (body == null) {
            this.noReplyLogger.log("No payload to send for exchange: " + exchange);
            callback.done(true);
            return true;
        }
        if (this.getConfiguration().isTextline()) {
            try {
                body = NettyHelper.getTextlineBody(body, exchange, this.getConfiguration().getDelimiter(), this.getConfiguration().isAutoAppendDelimiter());
            }
            catch (NoTypeConversionAvailableException e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        if (this.getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)this.getConfiguration().getCharsetName()));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Pool[active={}, idle={}]", (Object)this.pool.getNumActive(), (Object)this.pool.getNumIdle());
        }
        try {
            existing = (Channel)this.pool.borrowObject();
            if (existing != null) {
                LOG.trace("Got channel from pool {}", (Object)existing);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        if (existing == null) {
            exchange.setException((Throwable)new CamelExchangeException("Cannot get channel from pool", exchange));
            callback.done(true);
            return true;
        }
        final Channel channel = existing;
        final NettyProducerCallback producerCallback = new NettyProducerCallback(channel, callback);
        channel.setAttachment((Object)new NettyCamelState(producerCallback, exchange));
        NettyHelper.writeBodyAsync(LOG, channel, null, body, exchange, new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                LOG.trace("Operation complete {}", (Object)channelFuture);
                if (!channelFuture.isSuccess()) {
                    exchange.setException(channelFuture.getCause());
                    producerCallback.done(false);
                    return;
                }
                if (!NettyProducer.this.configuration.isSync()) {
                    try {
                        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
                        boolean disconnect = NettyProducer.this.getConfiguration().isDisconnect();
                        if (close != null) {
                            disconnect = close;
                        }
                        if (disconnect) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Closing channel when complete at address: {}", (Object)NettyProducer.this.getEndpoint().getConfiguration().getAddress());
                            }
                            NettyHelper.close(channel);
                        }
                    }
                    finally {
                        producerCallback.done(false);
                    }
                }
            }
        });
        return false;
    }

    public NettyCamelState getState(Channel channel) {
        return (NettyCamelState)channel.getAttachment();
    }

    public void removeState(Channel channel) {
        channel.setAttachment(null);
    }

    protected void setupTCPCommunication() throws Exception {
        if (this.channelFactory == null) {
            this.bossExecutor = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "NettyTCPBoss");
            this.workerExecutor = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "NettyTCPWorker");
            this.channelFactory = this.configuration.getWorkerCount() <= 0 ? new NioClientSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor) : new NioClientSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor, this.configuration.getWorkerCount());
        }
    }

    protected void setupUDPCommunication() throws Exception {
        if (this.datagramChannelFactory == null) {
            this.workerExecutor = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "NettyUDPWorker");
            this.datagramChannelFactory = this.configuration.getWorkerCount() <= 0 ? new NioDatagramChannelFactory((Executor)this.workerExecutor) : new NioDatagramChannelFactory((Executor)this.workerExecutor, this.configuration.getWorkerCount());
        }
    }

    private ChannelFuture openConnection() throws Exception {
        if (this.isTcp()) {
            ClientBootstrap clientBootstrap = new ClientBootstrap(this.channelFactory);
            clientBootstrap.setOption("keepAlive", (Object)this.configuration.isKeepAlive());
            clientBootstrap.setOption("tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
            clientBootstrap.setOption("reuseAddress", (Object)this.configuration.isReuseAddress());
            clientBootstrap.setOption("connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
            clientBootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
            ChannelFuture answer = clientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
            LOG.trace("Created new TCP client bootstrap connecting to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            return answer;
        }
        ConnectionlessBootstrap connectionlessClientBootstrap = new ConnectionlessBootstrap((ChannelFactory)this.datagramChannelFactory);
        connectionlessClientBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        connectionlessClientBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        connectionlessClientBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        connectionlessClientBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        connectionlessClientBootstrap.setOption("child.broadcast", (Object)this.configuration.isBroadcast());
        connectionlessClientBootstrap.setOption("sendBufferSize", (Object)this.configuration.getSendBufferSize());
        connectionlessClientBootstrap.setOption("receiveBufferSize", (Object)this.configuration.getReceiveBufferSize());
        connectionlessClientBootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
        Channel channel = connectionlessClientBootstrap.bind((SocketAddress)new InetSocketAddress(0));
        ALL_CHANNELS.add((Object)channel);
        ChannelFuture answer = connectionlessClientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        LOG.trace("Created new UDP client bootstrap connecting to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        return answer;
    }

    private Channel openChannel(ChannelFuture channelFuture) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        channelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                LOG.debug("Operation complete {}", (Object)channelFuture);
                latch.countDown();
            }
        });
        LOG.trace("Waiting for operation to complete {}", (Object)channelFuture);
        latch.await();
        if (!channelFuture.isSuccess()) {
            throw new CamelException("Cannot connect to " + this.configuration.getAddress(), channelFuture.getCause());
        }
        Channel answer = channelFuture.getChannel();
        ALL_CHANNELS.add((Object)answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: {}", (Object)this.configuration.getAddress());
        }
        return answer;
    }

    private void openAndCloseConnection() throws Exception {
        ChannelFuture future = this.openConnection();
        Channel channel = this.openChannel(future);
        NettyHelper.close(channel);
        ALL_CHANNELS.remove((Object)channel);
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public ChannelGroup getAllChannels() {
        return ALL_CHANNELS;
    }

    private final class NettyProducerPoolableObjectFactory
    implements PoolableObjectFactory<Channel> {
        private NettyProducerPoolableObjectFactory() {
        }

        public Channel makeObject() throws Exception {
            ChannelFuture channelFuture = NettyProducer.this.openConnection();
            Channel answer = NettyProducer.this.openChannel(channelFuture);
            LOG.trace("Created channel: {}", (Object)answer);
            return answer;
        }

        public void destroyObject(Channel channel) throws Exception {
            LOG.trace("Destroying channel: {}", (Object)channel);
            NettyHelper.close(channel);
            ALL_CHANNELS.remove((Object)channel);
        }

        public boolean validateObject(Channel channel) {
            boolean answer = channel.isConnected();
            LOG.trace("Validating channel: {} -> {}", (Object)channel, (Object)answer);
            return answer;
        }

        public void activateObject(Channel channel) throws Exception {
        }

        public void passivateObject(Channel channel) throws Exception {
        }
    }

    private final class NettyProducerCallback
    implements AsyncCallback {
        private final Channel channel;
        private final AsyncCallback callback;

        private NettyProducerCallback(Channel channel, AsyncCallback callback) {
            this.channel = channel;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(boolean doneSync) {
            try {
                LOG.trace("Putting channel back to pool {}", (Object)this.channel);
                NettyProducer.this.pool.returnObject((Object)this.channel);
            }
            catch (Exception e) {
                LOG.warn("Error returning channel to pool {}. This exception will be ignored.", (Object)this.channel);
            }
            finally {
                this.callback.done(doneSync);
            }
        }
    }
}

