/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.ssl;

import java.io.File;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.converter.IOConverter;

public class SSLEngineFactory {
    private static final String SSL_PROTOCOL = "TLS";
    private static SSLContext sslContext;

    public SSLEngineFactory(String keyStoreFormat, String securityProvider, File keyStoreFile, File trustStoreFile, char[] passphrase) throws Exception {
        KeyStore ks = KeyStore.getInstance(keyStoreFormat);
        ks.load(IOConverter.toInputStream((File)keyStoreFile), passphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(securityProvider);
        kmf.init(ks, passphrase);
        sslContext = SSLContext.getInstance(SSL_PROTOCOL);
        if (trustStoreFile != null) {
            KeyStore ts = KeyStore.getInstance(keyStoreFormat);
            ts.load(IOConverter.toInputStream((File)trustStoreFile), passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(securityProvider);
            tmf.init(ts);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        } else {
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
    }

    public SSLEngine createServerSSLEngine() {
        SSLEngine serverEngine = sslContext.createSSLEngine();
        serverEngine.setUseClientMode(false);
        serverEngine.setNeedClientAuth(true);
        return serverEngine;
    }

    public SSLEngine createClientSSLEngine() {
        SSLEngine clientEngine = sslContext.createSSLEngine();
        clientEngine.setUseClientMode(true);
        return clientEngine;
    }
}

