/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.handlers.ClientChannelHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ssl.SslHandler;

public class ClientPipelineFactory
implements ChannelPipelineFactory {
    private static final transient Log LOG = LogFactory.getLog(ClientPipelineFactory.class);
    private NettyProducer producer;
    private ChannelPipeline channelPipeline;

    public ClientPipelineFactory(NettyProducer producer) {
        this.producer = producer;
    }

    public ChannelPipeline getPipeline() throws Exception {
        if (this.channelPipeline != null) {
            if (this.channelPipeline.remove("ssl") != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Client SSL handler re-initialized on the ChannelPipeline");
                }
                this.channelPipeline.addFirst("ssl", (ChannelHandler)this.configureClientSSLOnDemand());
            }
            return this.channelPipeline;
        }
        this.channelPipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Client SSL handler configured and added to the ChannelPipeline");
            }
            this.channelPipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        List<ChannelUpstreamHandler> decoders = this.producer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            this.channelPipeline.addLast("decoder-" + x, (ChannelHandler)decoders.get(x));
        }
        List<ChannelDownstreamHandler> encoders = this.producer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            this.channelPipeline.addLast("encoder-" + x, (ChannelHandler)encoders.get(x));
        }
        if (this.producer.getConfiguration().getHandler() != null) {
            this.channelPipeline.addLast("handler", this.producer.getConfiguration().getHandler());
        } else {
            this.channelPipeline.addLast("handler", (ChannelHandler)new ClientChannelHandler(this.producer));
        }
        return this.channelPipeline;
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (!this.producer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.producer.getConfiguration().getSslHandler() != null) {
            return this.producer.getConfiguration().getSslHandler();
        }
        if (this.producer.getConfiguration().getKeyStoreFile() == null) {
            LOG.debug((Object)"keystorefile is null");
        }
        if (this.producer.getConfiguration().getTrustStoreFile() == null) {
            LOG.debug((Object)"truststorefile is null");
        }
        if (this.producer.getConfiguration().getPassphrase().toCharArray() == null) {
            LOG.debug((Object)"passphrase is null");
        }
        SSLEngineFactory sslEngineFactory = new SSLEngineFactory(this.producer.getConfiguration().getKeyStoreFormat(), this.producer.getConfiguration().getSecurityProvider(), this.producer.getConfiguration().getKeyStoreFile(), this.producer.getConfiguration().getTrustStoreFile(), this.producer.getConfiguration().getPassphrase().toCharArray());
        SSLEngine sslEngine = sslEngineFactory.createClientSSLEngine();
        return new SslHandler(sslEngine);
    }
}

