/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.util.URISupport;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.serialization.ObjectDecoder;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;
import org.jboss.netty.handler.ssl.SslHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConfiguration
implements Cloneable {
    private String protocol;
    private String host;
    private int port;
    private boolean keepAlive = true;
    private boolean tcpNoDelay = true;
    private boolean broadcast;
    private long connectTimeout = 10000L;
    private long timeout = 30000L;
    private boolean reuseAddress = true;
    private boolean sync = true;
    private String passphrase;
    private File keyStoreFile;
    private File trustStoreFile;
    private SslHandler sslHandler;
    private List<ChannelDownstreamHandler> encoders = new ArrayList<ChannelDownstreamHandler>();
    private List<ChannelUpstreamHandler> decoders = new ArrayList<ChannelUpstreamHandler>();
    private ChannelHandler handler;
    private boolean ssl;
    private long sendBufferSize = 65536L;
    private long receiveBufferSize = 65536L;
    private int corePoolSize = 10;
    private int maxPoolSize = 100;
    private String keyStoreFormat;
    private String securityProvider;
    private boolean disconnect;
    private boolean lazyChannelCreation = true;
    private boolean transferExchange;
    private boolean disconnectOnNoReply = true;
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;

    public NettyConfiguration copy() {
        try {
            NettyConfiguration answer = (NettyConfiguration)this.clone();
            ArrayList<ChannelDownstreamHandler> encodersCopy = new ArrayList<ChannelDownstreamHandler>(this.encoders);
            answer.setEncoders(encodersCopy);
            ArrayList<ChannelUpstreamHandler> decodersCopy = new ArrayList<ChannelUpstreamHandler>(this.decoders);
            answer.setDecoders(decodersCopy);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, NettyComponent component) throws Exception {
        this.protocol = uri.getScheme();
        if (!this.protocol.equalsIgnoreCase("tcp") && !this.protocol.equalsIgnoreCase("udp")) {
            throw new IllegalArgumentException("Unrecognized Netty protocol: " + this.protocol + " for uri: " + uri);
        }
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.sslHandler = (SslHandler)component.resolveAndRemoveReferenceParameter(parameters, "sslHandler", SslHandler.class, null);
        this.passphrase = (String)component.resolveAndRemoveReferenceParameter(parameters, "passphrase", String.class, null);
        this.keyStoreFormat = (String)component.getAndRemoveParameter(parameters, "keyStoreFormat", String.class, "JKS");
        this.securityProvider = (String)component.getAndRemoveParameter(parameters, "securityProvider", String.class, "SunX509");
        this.keyStoreFile = (File)component.resolveAndRemoveReferenceParameter(parameters, "keyStoreFile", File.class, null);
        this.trustStoreFile = (File)component.resolveAndRemoveReferenceParameter(parameters, "trustStoreFile", File.class, null);
        List referencedEncoders = component.resolveAndRemoveReferenceListParameter(parameters, "encoders", ChannelDownstreamHandler.class, null);
        this.addToHandlersList(this.encoders, referencedEncoders, ChannelDownstreamHandler.class);
        List referencedDecoders = component.resolveAndRemoveReferenceListParameter(parameters, "decoders", ChannelUpstreamHandler.class, null);
        this.addToHandlersList(this.decoders, referencedDecoders, ChannelUpstreamHandler.class);
        if (this.encoders.isEmpty() && this.decoders.isEmpty()) {
            this.encoders.add((ChannelDownstreamHandler)component.resolveAndRemoveReferenceParameter(parameters, "encoder", ChannelDownstreamHandler.class, new ObjectEncoder()));
            this.decoders.add((ChannelUpstreamHandler)component.resolveAndRemoveReferenceParameter(parameters, "decoder", ChannelUpstreamHandler.class, new ObjectDecoder()));
        }
        this.handler = (ChannelHandler)component.resolveAndRemoveReferenceParameter(parameters, "handler", SimpleChannelHandler.class, null);
        Map settings = URISupport.parseParameters((URI)uri);
        if (settings.containsKey("keepAlive")) {
            this.setKeepAlive(Boolean.valueOf((String)settings.get("keepAlive")));
        }
        if (settings.containsKey("tcpNoDelay")) {
            this.setTcpNoDelay(Boolean.valueOf((String)settings.get("tcpNoDelay")));
        }
        if (settings.containsKey("broadcast")) {
            this.setBroadcast(Boolean.valueOf((String)settings.get("broadcast")));
        }
        if (settings.containsKey("reuseAddress")) {
            this.setReuseAddress(Boolean.valueOf((String)settings.get("reuseAddress")));
        }
        if (settings.containsKey("connectTimeoutMillis")) {
            this.setConnectTimeout(Long.valueOf((String)settings.get("connectTimeoutMillis")));
        }
        if (settings.containsKey("sync")) {
            this.setTcpNoDelay(Boolean.valueOf((String)settings.get("sync")));
        }
        if (settings.containsKey("receiveTimeoutMillis")) {
            this.setTimeout(Long.valueOf((String)settings.get("receiveTimeoutMillis")));
        }
        if (settings.containsKey("sendBufferSize")) {
            this.setSendBufferSize(Long.valueOf((String)settings.get("sendBufferSize")));
        }
        if (settings.containsKey("receiveBufferSize")) {
            this.setReceiveBufferSize(Long.valueOf((String)settings.get("receiveBufferSize")));
        }
        if (settings.containsKey("ssl")) {
            this.setTcpNoDelay(Boolean.valueOf((String)settings.get("ssl")));
        }
        if (settings.containsKey("corePoolSize")) {
            this.setCorePoolSize(Integer.valueOf((String)settings.get("corePoolSize")));
        }
        if (settings.containsKey("maxPoolSize")) {
            this.setMaxPoolSize(Integer.valueOf((String)settings.get("maxPoolSize")));
        }
        if (settings.containsKey("disconnect")) {
            this.setDisconnect(Boolean.valueOf((String)settings.get("disconnect")));
        }
        if (settings.containsKey("lazyChannelCreation")) {
            this.setLazyChannelCreation(Boolean.valueOf((String)settings.get("lazyChannelCreation")));
        }
        if (settings.containsKey("transferExchange")) {
            this.setTransferExchange(Boolean.valueOf((String)settings.get("transferExchange")));
        }
        if (settings.containsKey("disconnectOnNoReply")) {
            this.setDisconnectOnNoReply(Boolean.valueOf((String)settings.get("disconnectOnNoReply")));
        }
        if (settings.containsKey("noReplyLogLevel")) {
            this.setNoReplyLogLevel(LoggingLevel.valueOf((String)((String)settings.get("noReplyLogLevel"))));
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public void setSslHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    public List<ChannelDownstreamHandler> getEncoders() {
        return this.encoders;
    }

    public List<ChannelUpstreamHandler> getDecoders() {
        return this.decoders;
    }

    public ChannelDownstreamHandler getEncoder() {
        return this.encoders.isEmpty() ? null : this.encoders.get(0);
    }

    public void setEncoder(ChannelDownstreamHandler encoder) {
        if (!this.encoders.contains(encoder)) {
            this.encoders.add(encoder);
        }
    }

    public void setEncoders(List<ChannelDownstreamHandler> encoders) {
        this.encoders = encoders;
    }

    public ChannelUpstreamHandler getDecoder() {
        return this.decoders.isEmpty() ? null : this.decoders.get(0);
    }

    public void setDecoder(ChannelUpstreamHandler decoder) {
        if (!this.decoders.contains(decoder)) {
            this.decoders.add(decoder);
        }
    }

    public void setDecoders(List<ChannelUpstreamHandler> decoders) {
        this.decoders = decoders;
    }

    public ChannelHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ChannelHandler handler) {
        this.handler = handler;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(long sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(long receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isLazyChannelCreation() {
        return this.lazyChannelCreation;
    }

    public void setLazyChannelCreation(boolean lazyChannelCreation) {
        this.lazyChannelCreation = lazyChannelCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    private <T> void addToHandlersList(List configured, List handlers, Class<? extends T> handlerType) {
        if (handlers != null) {
            for (int x = 0; x < handlers.size(); ++x) {
                Object handler = handlers.get(x);
                if (!handlerType.isInstance(handler)) continue;
                configured.add(handler);
            }
        }
    }
}

