/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class NettyConsumer
extends DefaultConsumer {
    private static final transient Log LOG = LogFactory.getLog(NettyConsumer.class);
    private final ChannelGroup allChannels;
    private CamelContext context = this.getEndpoint().getCamelContext();
    private NettyConfiguration configuration;
    private ChannelFactory channelFactory;
    private DatagramChannelFactory datagramChannelFactory;
    private ServerBootstrap serverBootstrap;
    private ConnectionlessBootstrap connectionlessServerBootstrap;
    private Channel channel;

    public NettyConsumer(NettyEndpoint nettyEndpoint, Processor processor, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint, processor);
        this.configuration = configuration;
        this.allChannels = new DefaultChannelGroup("NettyProducer-" + nettyEndpoint.getEndpointUri());
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.getProtocol().equalsIgnoreCase("udp")) {
            this.initializeUDPServerSocketCommunicationLayer();
        } else {
            this.initializeTCPServerSocketCommunicationLayer();
        }
        LOG.info((Object)("Netty consumer bound to: " + this.configuration.getAddress()));
    }

    protected void doStop() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Netty consumer unbinding from: " + this.configuration.getAddress()));
        }
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
        super.doStop();
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public DatagramChannelFactory getDatagramChannelFactory() {
        return this.datagramChannelFactory;
    }

    public void setDatagramChannelFactory(DatagramChannelFactory datagramChannelFactory) {
        this.datagramChannelFactory = datagramChannelFactory;
    }

    public ServerBootstrap getServerBootstrap() {
        return this.serverBootstrap;
    }

    public void setServerBootstrap(ServerBootstrap serverBootstrap) {
        this.serverBootstrap = serverBootstrap;
    }

    public ConnectionlessBootstrap getConnectionlessServerBootstrap() {
        return this.connectionlessServerBootstrap;
    }

    public void setConnectionlessServerBootstrap(ConnectionlessBootstrap connectionlessServerBootstrap) {
        this.connectionlessServerBootstrap = connectionlessServerBootstrap;
    }

    private void initializeTCPServerSocketCommunicationLayer() throws Exception {
        ExecutorService bossExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyTCPBoss", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
        ExecutorService workerExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyTCPWorker", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
        this.channelFactory = new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        this.serverBootstrap = new ServerBootstrap(this.channelFactory);
        this.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)new ServerPipelineFactory(this));
        this.serverBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        this.serverBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        this.serverBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        this.channel = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        this.allChannels.add((Object)this.channel);
    }

    private void initializeUDPServerSocketCommunicationLayer() throws Exception {
        ExecutorService workerExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyUDPWorker", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
        this.datagramChannelFactory = new NioDatagramChannelFactory((Executor)workerExecutor);
        this.connectionlessServerBootstrap = new ConnectionlessBootstrap((ChannelFactory)this.datagramChannelFactory);
        this.connectionlessServerBootstrap.setPipelineFactory((ChannelPipelineFactory)new ServerPipelineFactory(this));
        this.connectionlessServerBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        this.connectionlessServerBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        this.connectionlessServerBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        this.connectionlessServerBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        this.connectionlessServerBootstrap.setOption("child.broadcast", (Object)this.configuration.isBroadcast());
        this.connectionlessServerBootstrap.setOption("sendBufferSize", (Object)this.configuration.getSendBufferSize());
        this.connectionlessServerBootstrap.setOption("receiveBufferSize", (Object)this.configuration.getReceiveBufferSize());
        this.channel = this.connectionlessServerBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        this.allChannels.add((Object)this.channel);
    }
}

