/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;

public class NettyEndpoint
extends DefaultEndpoint {
    private NettyConfiguration configuration;

    public NettyEndpoint(String endpointUri, Component component, NettyConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new NettyConsumer(this, processor, this.configuration);
    }

    public Producer createProducer() throws Exception {
        return new NettyProducer(this, this.configuration);
    }

    public Exchange createExchange(ChannelHandlerContext ctx, MessageEvent messageEvent) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setHeader("CamelNettyChannelHandlerContext", (Object)ctx);
        exchange.getIn().setHeader("CamelNettyMessageEvent", (Object)messageEvent);
        exchange.getIn().setHeader("CamelNettyRemoteAddress", (Object)messageEvent.getRemoteAddress());
        NettyPayloadHelper.setIn(exchange, messageEvent.getMessage());
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }
}

