/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.SocketAddress;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;

public final class NettyHelper {
    private static final transient Log LOG = LogFactory.getLog(NettyHelper.class);

    private NettyHelper() {
    }

    public static void writeBody(Channel channel, SocketAddress remoteAddress, Object body, Exchange exchange) throws CamelExchangeException {
        ChannelFuture future = remoteAddress != null ? channel.write(body, remoteAddress) : channel.write(body);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Waiting for write to complete");
        }
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            LOG.warn((Object)("Cannot write body: " + body + " using channel: " + channel));
            throw new CamelExchangeException("Cannot write body", exchange, future.getCause());
        }
    }

    public static void close(Channel channel) {
        if (channel != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Closing channel: " + channel));
            }
            channel.close().awaitUninterruptibly();
        }
    }
}

