/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.handlers.ClientChannelHandler;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.Logger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;

public class NettyProducer
extends DefaultProducer
implements ServicePoolAware {
    private static final transient Log LOG = LogFactory.getLog(NettyProducer.class);
    private final ChannelGroup allChannels;
    private CamelContext context;
    private NettyConfiguration configuration;
    private CountDownLatch countdownLatch;
    private ChannelFactory channelFactory;
    private DatagramChannelFactory datagramChannelFactory;
    private Channel channel;
    private ClientBootstrap clientBootstrap;
    private ConnectionlessBootstrap connectionlessClientBootstrap;
    private ClientPipelineFactory clientPipelineFactory;
    private ChannelPipeline clientPipeline;
    private Logger noReplyLogger;

    public NettyProducer(NettyEndpoint nettyEndpoint, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint);
        this.configuration = configuration;
        this.context = this.getEndpoint().getCamelContext();
        this.allChannels = new DefaultChannelGroup("NettyProducer-" + nettyEndpoint.getEndpointUri());
        this.noReplyLogger = new Logger(LOG, configuration.getNoReplyLogLevel());
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    public boolean isSingleton() {
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.getProtocol().equalsIgnoreCase("udp")) {
            this.setupUDPCommunication();
        } else {
            this.setupTCPCommunication();
        }
        if (!this.configuration.isLazyChannelCreation()) {
            this.openConnection();
        }
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stopping producer at address: " + this.configuration.getAddress()));
        }
        this.closeConnection();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        Object body;
        if (this.channel == null && !this.configuration.isLazyChannelCreation()) {
            throw new IllegalStateException("Not started yet!");
        }
        if (this.channel == null || !this.channel.isConnected()) {
            this.openConnection();
        }
        if ((body = NettyPayloadHelper.getIn(this.getEndpoint(), exchange)) == null) {
            this.noReplyLogger.log("No payload to send for exchange: " + exchange);
            return;
        }
        if (this.configuration.isSync()) {
            this.countdownLatch = new CountDownLatch(1);
        }
        if (LOG.isDebugEnabled()) {
            Object out = body;
            if (body instanceof byte[]) {
                out = exchange.getContext().getTypeConverter().convertTo(String.class, body);
            }
            LOG.debug((Object)("Writing body : " + out));
        }
        NettyHelper.writeBody(this.channel, null, body, exchange);
        if (this.configuration.isSync()) {
            boolean success = this.countdownLatch.await(this.configuration.getTimeout(), TimeUnit.MILLISECONDS);
            if (!success) {
                throw new ExchangeTimedOutException(exchange, this.configuration.getTimeout());
            }
            ClientChannelHandler handler = (ClientChannelHandler)this.clientPipeline.get("handler");
            if (handler.getCause() != null) {
                throw new CamelExchangeException("Error occurred in ClientChannelHandler", exchange, handler.getCause());
            }
            if (!handler.isMessageReceived()) {
                throw new CamelExchangeException("No response received from remote server: " + this.configuration.getAddress(), exchange);
            }
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                NettyPayloadHelper.setOut(exchange, handler.getMessage());
            } else {
                NettyPayloadHelper.setIn(exchange, handler.getMessage());
            }
        }
        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
        boolean disconnect = this.getConfiguration().isDisconnect();
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing channel when complete at address: " + this.getEndpoint().getConfiguration().getAddress()));
            }
            NettyHelper.close(this.channel);
        }
    }

    protected void setupTCPCommunication() throws Exception {
        if (this.channelFactory == null) {
            ExecutorService bossExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyTCPBoss", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
            ExecutorService workerExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyTCPWorker", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
            this.channelFactory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        }
        if (this.clientBootstrap == null) {
            this.clientBootstrap = new ClientBootstrap(this.channelFactory);
            this.clientBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
            this.clientBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
            this.clientBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
            this.clientBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        }
    }

    protected void setupUDPCommunication() throws Exception {
        if (this.datagramChannelFactory == null) {
            ExecutorService workerExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyUDPWorker", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
            this.datagramChannelFactory = new NioDatagramChannelFactory((Executor)workerExecutor);
        }
        if (this.connectionlessClientBootstrap == null) {
            this.connectionlessClientBootstrap = new ConnectionlessBootstrap((ChannelFactory)this.datagramChannelFactory);
            this.connectionlessClientBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
            this.connectionlessClientBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
            this.connectionlessClientBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
            this.connectionlessClientBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
            this.connectionlessClientBootstrap.setOption("child.broadcast", (Object)this.configuration.isBroadcast());
            this.connectionlessClientBootstrap.setOption("sendBufferSize", (Object)this.configuration.getSendBufferSize());
            this.connectionlessClientBootstrap.setOption("receiveBufferSize", (Object)this.configuration.getReceiveBufferSize());
        }
    }

    private void openConnection() throws Exception {
        ChannelFuture channelFuture;
        if (this.clientPipelineFactory == null) {
            this.clientPipelineFactory = new ClientPipelineFactory(this);
        }
        this.clientPipeline = this.clientPipelineFactory.getPipeline();
        if (this.clientBootstrap != null) {
            this.clientBootstrap.setPipeline(this.clientPipeline);
            channelFuture = this.clientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        } else if (this.connectionlessClientBootstrap != null) {
            this.connectionlessClientBootstrap.setPipeline(this.clientPipeline);
            this.connectionlessClientBootstrap.bind((SocketAddress)new InetSocketAddress(0));
            channelFuture = this.connectionlessClientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        } else {
            throw new IllegalStateException("Should either be TCP or UDP");
        }
        channelFuture.awaitUninterruptibly();
        if (!channelFuture.isSuccess()) {
            throw new CamelException("Cannot connect to " + this.configuration.getAddress(), channelFuture.getCause());
        }
        this.channel = channelFuture.getChannel();
        this.allChannels.add((Object)this.channel);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating connector to address: " + this.configuration.getAddress()));
        }
    }

    private void closeConnection() throws Exception {
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public CountDownLatch getCountdownLatch() {
        return this.countdownLatch;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public ClientBootstrap getClientBootstrap() {
        return this.clientBootstrap;
    }

    public void setClientBootstrap(ClientBootstrap clientBootstrap) {
        this.clientBootstrap = clientBootstrap;
    }

    public ClientPipelineFactory getClientPipelineFactory() {
        return this.clientPipelineFactory;
    }

    public void setClientPipelineFactory(ClientPipelineFactory clientPipelineFactory) {
        this.clientPipelineFactory = clientPipelineFactory;
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }
}

