/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

@ChannelPipelineCoverage(value="all")
public class ClientChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final transient Log LOG = LogFactory.getLog(ClientChannelHandler.class);
    private NettyProducer producer;
    private Object message;
    private Throwable cause;
    private boolean messageReceived;

    public ClientChannelHandler(NettyProducer producer) {
        this.producer = producer;
    }

    public void reset() {
        this.message = null;
        this.cause = null;
        this.messageReceived = false;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent channelStateEvent) throws Exception {
        this.producer.getAllChannels().add((Object)channelStateEvent.getChannel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        this.message = null;
        this.messageReceived = false;
        this.cause = exceptionEvent.getCause();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Closing channel as an exception was thrown from Netty", this.cause);
        }
        NettyHelper.close(exceptionEvent.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.producer.getConfiguration().isSync() && !this.messageReceived) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Channel closed but no message received from address: " + this.producer.getConfiguration().getAddress()));
            }
            this.countDown();
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        this.message = messageEvent.getMessage();
        this.messageReceived = true;
        this.cause = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Message received: " + this.message));
        }
        this.countDown();
    }

    protected void countDown() {
        if (this.producer.getConfiguration().isSync()) {
            this.producer.getCountdownLatch().countDown();
        }
    }

    public Object getMessage() {
        return this.message;
    }

    public boolean isMessageReceived() {
        return this.messageReceived;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

