/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.processor.Logger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

@ChannelPipelineCoverage(value="all")
public class ServerChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final transient Log LOG = LogFactory.getLog(ServerChannelHandler.class);
    private NettyConsumer consumer;
    private Logger noReplyLogger;

    public ServerChannelHandler(NettyConsumer consumer) {
        this.consumer = consumer;
        this.noReplyLogger = new Logger(LOG, consumer.getConfiguration().getNoReplyLogLevel());
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent channelStateEvent) throws Exception {
        this.consumer.getAllChannels().add((Object)channelStateEvent.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.debug((Object)("Channel closed: " + e.getChannel()));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        LOG.warn((Object)"Closing channel as an exception was thrown from Netty", exceptionEvent.getCause());
        NettyHelper.close(exceptionEvent.getChannel());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        Object in = messageEvent.getMessage();
        if (LOG.isDebugEnabled()) {
            if (in instanceof byte[]) {
                in = this.consumer.getEndpoint().getCamelContext().getTypeConverter().convertTo(String.class, in);
            }
            LOG.debug((Object)("Incoming message: " + in));
        }
        Exchange exchange = this.consumer.getEndpoint().createExchange(ctx, messageEvent);
        if (this.consumer.getConfiguration().isSync()) {
            exchange.setPattern(ExchangePattern.InOut);
        }
        try {
            this.consumer.getProcessor().process(exchange);
        }
        catch (Throwable e) {
            this.consumer.getExceptionHandler().handleException(e);
        }
        if (this.consumer.getConfiguration().isSync()) {
            this.sendResponse(messageEvent, exchange);
        }
    }

    private void sendResponse(MessageEvent messageEvent, Exchange exchange) throws Exception {
        Object body = ExchangeHelper.isOutCapable((Exchange)exchange) ? NettyPayloadHelper.getOut(this.consumer.getEndpoint(), exchange) : NettyPayloadHelper.getIn(this.consumer.getEndpoint(), exchange);
        boolean failed = exchange.isFailed();
        if (failed && !this.consumer.getEndpoint().getConfiguration().isTransferExchange()) {
            body = exchange.getException() != null ? exchange.getException() : exchange.getOut().getBody();
        }
        if (body == null) {
            this.noReplyLogger.log("No payload to send as reply for exchange: " + exchange);
            if (this.consumer.getConfiguration().isDisconnectOnNoReply()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Closing channel as no payload to send as reply at address: " + messageEvent.getRemoteAddress()));
                }
                NettyHelper.close(messageEvent.getChannel());
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Writing body: " + body));
            }
            if (this.consumer.getConfiguration().getProtocol().equalsIgnoreCase("udp")) {
                NettyHelper.writeBody(messageEvent.getChannel(), messageEvent.getRemoteAddress(), body, exchange);
            } else {
                NettyHelper.writeBody(messageEvent.getChannel(), null, body, exchange);
            }
        }
        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
        boolean disconnect = this.consumer.getConfiguration().isDisconnect();
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing channel when complete at address: " + messageEvent.getRemoteAddress()));
            }
            NettyHelper.close(messageEvent.getChannel());
        }
    }
}

