/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class NettyComponent
extends DefaultComponent {
    private static volatile Timer timer;
    private NettyConfiguration configuration;

    public NettyComponent() {
    }

    public NettyComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        NettyConfiguration config = this.configuration != null ? this.configuration.copy() : new NettyConfiguration();
        config.parseURI(new URI(remaining), parameters, this);
        NettyEndpoint nettyEndpoint = new NettyEndpoint(remaining, this, config);
        nettyEndpoint.setTimer(NettyComponent.getTimer());
        this.setProperties(nettyEndpoint.getConfiguration(), parameters);
        return nettyEndpoint;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public static Timer getTimer() {
        return timer;
    }

    protected void doStart() throws Exception {
        if (timer == null) {
            timer = new HashedWheelTimer();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        timer.stop();
        timer = null;
        super.doStop();
    }
}

