/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.DynamicChannelBuffer;

@Converter
public final class NettyConverter {
    private NettyConverter() {
    }

    @Converter
    public static byte[] toByteArray(ChannelBuffer buffer) {
        return buffer.array();
    }

    @Converter
    public static String toString(ChannelBuffer buffer, Exchange exchange) {
        byte[] bytes = NettyConverter.toByteArray(buffer);
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)bytes);
    }

    @Converter
    public static InputStream toInputStream(ChannelBuffer buffer) {
        return new ChannelBufferInputStream(buffer);
    }

    @Converter
    public static ObjectInput toObjectInput(ChannelBuffer buffer) throws IOException {
        InputStream is = NettyConverter.toInputStream(buffer);
        return new ObjectInputStream(is);
    }

    @Converter
    public static ChannelBuffer toByteBuffer(byte[] bytes) {
        DynamicChannelBuffer buf = new DynamicChannelBuffer(bytes.length);
        buf.writeBytes(bytes);
        return buf;
    }
}

