/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.DefaultClientPipelineFactory;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyProducer
extends DefaultAsyncProducer
implements ServicePoolAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(NettyProducer.class);
    private static final ChannelGroup ALL_CHANNELS = new DefaultChannelGroup("NettyProducer");
    private CamelContext context;
    private NettyConfiguration configuration;
    private ChannelFactory channelFactory;
    private DatagramChannelFactory datagramChannelFactory;
    private CamelLogger noReplyLogger;

    public NettyProducer(NettyEndpoint nettyEndpoint, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint);
        this.configuration = configuration;
        this.context = this.getEndpoint().getCamelContext();
        this.noReplyLogger = new CamelLogger(LOG, configuration.getNoReplyLogLevel());
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    public boolean isSingleton() {
        return false;
    }

    public CamelContext getContext() {
        return this.context;
    }

    protected boolean isTcp() {
        return this.configuration.getProtocol().equalsIgnoreCase("tcp");
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isTcp()) {
            this.setupTCPCommunication();
        } else {
            this.setupUDPCommunication();
        }
        if (!this.configuration.isLazyChannelCreation()) {
            this.openAndCloseConnection();
        }
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping producer at address: " + this.configuration.getAddress());
        }
        ChannelGroupFuture future = ALL_CHANNELS.close();
        future.awaitUninterruptibly();
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
        super.doStop();
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Channel channel;
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        Object body = NettyPayloadHelper.getIn(this.getEndpoint(), exchange);
        if (body == null) {
            this.noReplyLogger.log("No payload to send for exchange: " + exchange);
            callback.done(true);
            return true;
        }
        if (this.getConfiguration().isTextline()) {
            try {
                body = NettyHelper.getTextlineBody(body, exchange, this.getConfiguration().getDelimiter(), this.getConfiguration().isAutoAppendDelimiter());
            }
            catch (NoTypeConversionAvailableException e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        if (this.getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOConverter.normalizeCharset((String)this.getConfiguration().getCharsetName()));
        }
        try {
            ChannelFuture channelFuture = this.openConnection(exchange, callback);
            channel = this.openChannel(channelFuture);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing body: " + body);
        }
        ChannelFuture future = channel.write(body);
        future.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Operation complete " + channelFuture);
                }
                if (!channelFuture.isSuccess()) {
                    exchange.setException(channelFuture.getCause());
                    callback.done(false);
                    return;
                }
                if (!NettyProducer.this.configuration.isSync()) {
                    try {
                        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
                        boolean disconnect = NettyProducer.this.getConfiguration().isDisconnect();
                        if (close != null) {
                            disconnect = close;
                        }
                        if (disconnect) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Closing channel when complete at address: " + NettyProducer.this.getEndpoint().getConfiguration().getAddress());
                            }
                            NettyHelper.close(channel);
                        }
                    }
                    finally {
                        callback.done(false);
                    }
                }
            }
        });
        return false;
    }

    protected void setupTCPCommunication() throws Exception {
        if (this.channelFactory == null) {
            ExecutorService bossExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyTCPBoss", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
            ExecutorService workerExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyTCPWorker", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
            this.channelFactory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        }
    }

    protected void setupUDPCommunication() throws Exception {
        if (this.datagramChannelFactory == null) {
            ExecutorService workerExecutor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "NettyUDPWorker", this.configuration.getCorePoolSize(), this.configuration.getMaxPoolSize());
            this.datagramChannelFactory = new NioDatagramChannelFactory((Executor)workerExecutor);
        }
    }

    private ChannelFuture openConnection(Exchange exchange, AsyncCallback callback) throws Exception {
        ChannelPipeline clientPipeline;
        if (this.configuration.getClientPipelineFactory() != null) {
            this.configuration.getClientPipelineFactory().setProducer(this);
            this.configuration.getClientPipelineFactory().setExchange(exchange);
            this.configuration.getClientPipelineFactory().setCallback(callback);
            clientPipeline = this.configuration.getClientPipelineFactory().getPipeline();
        } else {
            DefaultClientPipelineFactory clientPipelineFactory = new DefaultClientPipelineFactory(this, exchange, callback);
            clientPipeline = ((ClientPipelineFactory)clientPipelineFactory).getPipeline();
        }
        if (this.isTcp()) {
            ClientBootstrap clientBootstrap = new ClientBootstrap(this.channelFactory);
            clientBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
            clientBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
            clientBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
            clientBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
            clientBootstrap.setPipeline(clientPipeline);
            ChannelFuture answer = clientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
            return answer;
        }
        ConnectionlessBootstrap connectionlessClientBootstrap = new ConnectionlessBootstrap((ChannelFactory)this.datagramChannelFactory);
        connectionlessClientBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        connectionlessClientBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        connectionlessClientBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        connectionlessClientBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        connectionlessClientBootstrap.setOption("child.broadcast", (Object)this.configuration.isBroadcast());
        connectionlessClientBootstrap.setOption("sendBufferSize", (Object)this.configuration.getSendBufferSize());
        connectionlessClientBootstrap.setOption("receiveBufferSize", (Object)this.configuration.getReceiveBufferSize());
        connectionlessClientBootstrap.setPipeline(clientPipeline);
        connectionlessClientBootstrap.bind((SocketAddress)new InetSocketAddress(0));
        ChannelFuture answer = connectionlessClientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        return answer;
    }

    private Channel openChannel(ChannelFuture channelFuture) throws Exception {
        channelFuture.awaitUninterruptibly();
        if (!channelFuture.isSuccess()) {
            throw new CamelException("Cannot connect to " + this.configuration.getAddress(), channelFuture.getCause());
        }
        Channel channel = channelFuture.getChannel();
        ALL_CHANNELS.add((Object)channel);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: " + this.configuration.getAddress());
        }
        return channel;
    }

    private void openAndCloseConnection() throws Exception {
        ChannelFuture future = this.openConnection((Exchange)new DefaultExchange(this.context), new AsyncCallback(){

            public void done(boolean doneSync) {
            }
        });
        Channel channel = this.openChannel(future);
        NettyHelper.close(channel);
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public ChannelGroup getAllChannels() {
        return ALL_CHANNELS;
    }
}

