/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.handlers.ServerChannelHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerPipelineFactory
implements ChannelPipelineFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultServerPipelineFactory.class);
    private NettyConsumer consumer;

    public DefaultServerPipelineFactory(NettyConsumer consumer) {
        this.consumer = consumer;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline channelPipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            LOG.debug("Server SSL handler configured and added as an interceptor against the ChannelPipeline");
            channelPipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        List<ChannelDownstreamHandler> encoders = this.consumer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            channelPipeline.addLast("encoder-" + x, (ChannelHandler)encoders.get(x));
        }
        List<ChannelUpstreamHandler> decoders = this.consumer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            channelPipeline.addLast("decoder-" + x, (ChannelHandler)decoders.get(x));
        }
        channelPipeline.addLast("handler", (ChannelHandler)new ServerChannelHandler(this.consumer));
        return channelPipeline;
    }

    private SslHandler configureServerSSLOnDemand() throws Exception {
        if (!this.consumer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.consumer.getConfiguration().getSslHandler() != null) {
            return this.consumer.getConfiguration().getSslHandler();
        }
        SSLEngineFactory sslEngineFactory = new SSLEngineFactory(this.consumer.getConfiguration().getKeyStoreFormat(), this.consumer.getConfiguration().getSecurityProvider(), this.consumer.getConfiguration().getKeyStoreFile(), this.consumer.getConfiguration().getTrustStoreFile(), this.consumer.getConfiguration().getPassphrase().toCharArray());
        SSLEngine sslEngine = sslEngineFactory.createServerSSLEngine();
        return new SslHandler(sslEngine);
    }
}

