/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.SocketAddress;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(NettyHelper.class);

    private NettyHelper() {
    }

    public static String getTextlineBody(Object body, Exchange exchange, TextLineDelimiter delimiter, boolean autoAppendDelimiter) throws NoTypeConversionAvailableException {
        String s = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, body);
        if (autoAppendDelimiter) {
            if (TextLineDelimiter.LINE.equals((Object)delimiter)) {
                if (!s.endsWith("\n")) {
                    LOG.trace("Auto appending missing newline delimiter to body");
                    s = s + "\n";
                }
            } else if (!s.endsWith("\u0000")) {
                LOG.trace("Auto appending missing null delimiter to body");
                s = s + "\u0000";
            }
        }
        return s;
    }

    public static void writeBodySync(Channel channel, SocketAddress remoteAddress, Object body, Exchange exchange) throws CamelExchangeException {
        ChannelFuture future = remoteAddress != null ? channel.write(body, remoteAddress) : channel.write(body);
        LOG.trace("Waiting for write to complete");
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            LOG.warn("Cannot write body: " + body + " using channel: " + channel);
            throw new CamelExchangeException("Cannot write body", exchange, future.getCause());
        }
    }

    public static void close(Channel channel) {
        if (channel != null) {
            LOG.trace("Closing channel: {}", (Object)channel);
            channel.close().awaitUninterruptibly();
        }
    }
}

