/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.handlers.ClientChannelHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientPipelineFactory
extends ClientPipelineFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(ClientPipelineFactory.class);

    public DefaultClientPipelineFactory(NettyProducer producer, Exchange exchange, AsyncCallback callback) {
        super(producer, exchange, callback);
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline channelPipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            LOG.debug("Client SSL handler configured and added to the ChannelPipeline");
            channelPipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        List<ChannelUpstreamHandler> decoders = this.producer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            channelPipeline.addLast("decoder-" + x, (ChannelHandler)decoders.get(x));
        }
        List<ChannelDownstreamHandler> encoders = this.producer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            channelPipeline.addLast("encoder-" + x, (ChannelHandler)encoders.get(x));
        }
        channelPipeline.addLast("handler", (ChannelHandler)new ClientChannelHandler(this.producer, this.exchange, this.callback));
        return channelPipeline;
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (!this.producer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.producer.getConfiguration().getSslHandler() != null) {
            return this.producer.getConfiguration().getSslHandler();
        }
        if (this.producer.getConfiguration().getKeyStoreFile() == null) {
            LOG.debug("keystorefile is null");
        }
        if (this.producer.getConfiguration().getTrustStoreFile() == null) {
            LOG.debug("truststorefile is null");
        }
        if (this.producer.getConfiguration().getPassphrase().toCharArray() == null) {
            LOG.debug("passphrase is null");
        }
        SSLEngineFactory sslEngineFactory = new SSLEngineFactory(this.producer.getConfiguration().getKeyStoreFormat(), this.producer.getConfiguration().getSecurityProvider(), this.producer.getConfiguration().getKeyStoreFile(), this.producer.getConfiguration().getTrustStoreFile(), this.producer.getConfiguration().getPassphrase().toCharArray());
        SSLEngine sslEngine = sslEngineFactory.createClientSSLEngine();
        return new SslHandler(sslEngine);
    }
}

