/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.util.EndpointHelper;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.codec.serialization.ObjectDecoder;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfiguration
implements Cloneable {
    private static final transient Logger LOG = LoggerFactory.getLogger(NettyConfiguration.class);
    private String protocol;
    private String host;
    private int port;
    private boolean keepAlive = true;
    private boolean tcpNoDelay = true;
    private boolean broadcast;
    private long connectTimeout = 10000L;
    private boolean reuseAddress = true;
    private boolean sync = true;
    private boolean textline;
    private TextLineDelimiter delimiter = TextLineDelimiter.LINE;
    private boolean autoAppendDelimiter = true;
    private int decoderMaxLineLength = 1024;
    private String encoding;
    private String passphrase;
    private File keyStoreFile;
    private File trustStoreFile;
    private SslHandler sslHandler;
    private List<ChannelDownstreamHandler> encoders = new ArrayList<ChannelDownstreamHandler>();
    private List<ChannelUpstreamHandler> decoders = new ArrayList<ChannelUpstreamHandler>();
    private boolean ssl;
    private long sendBufferSize = 65536L;
    private long receiveBufferSize = 65536L;
    private int receiveBufferSizePredictor;
    private int corePoolSize = 10;
    private int maxPoolSize = 100;
    private int workerCount;
    private String keyStoreFormat;
    private String securityProvider;
    private boolean disconnect;
    private boolean lazyChannelCreation = true;
    private boolean transferExchange;
    private boolean disconnectOnNoReply = true;
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;
    private boolean allowDefaultCodec = true;
    private ClientPipelineFactory clientPipelineFactory;
    private ServerPipelineFactory serverPipelineFactory;

    public NettyConfiguration copy() {
        try {
            NettyConfiguration answer = (NettyConfiguration)this.clone();
            ArrayList<ChannelDownstreamHandler> encodersCopy = new ArrayList<ChannelDownstreamHandler>(this.encoders);
            answer.setEncoders(encodersCopy);
            ArrayList<ChannelUpstreamHandler> decodersCopy = new ArrayList<ChannelUpstreamHandler>(this.decoders);
            answer.setDecoders(decodersCopy);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, NettyComponent component) throws Exception {
        this.protocol = uri.getScheme();
        if (!this.protocol.equalsIgnoreCase("tcp") && !this.protocol.equalsIgnoreCase("udp")) {
            throw new IllegalArgumentException("Unrecognized Netty protocol: " + this.protocol + " for uri: " + uri);
        }
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.sslHandler = (SslHandler)component.resolveAndRemoveReferenceParameter(parameters, "sslHandler", SslHandler.class, null);
        this.passphrase = (String)component.resolveAndRemoveReferenceParameter(parameters, "passphrase", String.class, null);
        this.keyStoreFormat = (String)component.getAndRemoveParameter(parameters, "keyStoreFormat", String.class, "JKS");
        this.securityProvider = (String)component.getAndRemoveParameter(parameters, "securityProvider", String.class, "SunX509");
        this.keyStoreFile = (File)component.resolveAndRemoveReferenceParameter(parameters, "keyStoreFile", File.class, null);
        this.trustStoreFile = (File)component.resolveAndRemoveReferenceParameter(parameters, "trustStoreFile", File.class, null);
        this.clientPipelineFactory = (ClientPipelineFactory)component.resolveAndRemoveReferenceParameter(parameters, "clientPipelineFactory", ClientPipelineFactory.class, null);
        this.serverPipelineFactory = (ServerPipelineFactory)component.resolveAndRemoveReferenceParameter(parameters, "serverPipelineFactory", ServerPipelineFactory.class, null);
        List referencedEncoders = component.resolveAndRemoveReferenceListParameter(parameters, "encoders", ChannelDownstreamHandler.class, null);
        this.addToHandlersList(this.encoders, referencedEncoders, ChannelDownstreamHandler.class);
        List referencedDecoders = component.resolveAndRemoveReferenceListParameter(parameters, "decoders", ChannelUpstreamHandler.class, null);
        this.addToHandlersList(this.decoders, referencedDecoders, ChannelUpstreamHandler.class);
        EndpointHelper.setReferenceProperties((CamelContext)component.getCamelContext(), (Object)this, parameters);
        EndpointHelper.setProperties((CamelContext)component.getCamelContext(), (Object)this, parameters);
        if (this.encoders.isEmpty() && this.decoders.isEmpty()) {
            if (this.allowDefaultCodec) {
                if (this.isTextline()) {
                    Charset charset = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : CharsetUtil.UTF_8;
                    this.encoders.add((ChannelDownstreamHandler)new StringEncoder(charset));
                    this.decoders.add((ChannelUpstreamHandler)new DelimiterBasedFrameDecoder(this.decoderMaxLineLength, true, this.delimiter == TextLineDelimiter.LINE ? Delimiters.lineDelimiter() : Delimiters.nulDelimiter()));
                    this.decoders.add((ChannelUpstreamHandler)new StringDecoder(charset));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using textline encoders and decoders with charset: {}, delimiter: {} and decoderMaxLineLength: {}", new Object[]{charset, this.delimiter, this.decoderMaxLineLength});
                    }
                } else {
                    this.encoders.add((ChannelDownstreamHandler)new ObjectEncoder());
                    this.decoders.add((ChannelUpstreamHandler)new ObjectDecoder());
                    LOG.debug("Using object encoders and decoders");
                }
            } else {
                LOG.debug("No encoders and decoders will be used");
            }
        } else {
            LOG.debug("Using configured encoders and/or decoders");
        }
    }

    public String getCharsetName() {
        if (this.encoding == null) {
            return null;
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding).name();
    }

    public boolean isTcp() {
        return this.protocol.equalsIgnoreCase("tcp");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public int getDecoderMaxLineLength() {
        return this.decoderMaxLineLength;
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoderMaxLineLength = decoderMaxLineLength;
    }

    public TextLineDelimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(TextLineDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isAutoAppendDelimiter() {
        return this.autoAppendDelimiter;
    }

    public void setAutoAppendDelimiter(boolean autoAppendDelimiter) {
        this.autoAppendDelimiter = autoAppendDelimiter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public void setSslHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    public List<ChannelDownstreamHandler> getEncoders() {
        return this.encoders;
    }

    public List<ChannelUpstreamHandler> getDecoders() {
        return this.decoders;
    }

    public ChannelDownstreamHandler getEncoder() {
        return this.encoders.isEmpty() ? null : this.encoders.get(0);
    }

    public void setEncoder(ChannelDownstreamHandler encoder) {
        if (!this.encoders.contains(encoder)) {
            this.encoders.add(encoder);
        }
    }

    public void setEncoders(List<ChannelDownstreamHandler> encoders) {
        this.encoders = encoders;
    }

    public ChannelUpstreamHandler getDecoder() {
        return this.decoders.isEmpty() ? null : this.decoders.get(0);
    }

    public void setDecoder(ChannelUpstreamHandler decoder) {
        if (!this.decoders.contains(decoder)) {
            this.decoders.add(decoder);
        }
    }

    public void setDecoders(List<ChannelUpstreamHandler> decoders) {
        this.decoders = decoders;
    }

    public long getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(long sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(long receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSizePredictor() {
        return this.receiveBufferSizePredictor;
    }

    public void setReceiveBufferSizePredictor(int receiveBufferSizePredictor) {
        this.receiveBufferSizePredictor = receiveBufferSizePredictor;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isLazyChannelCreation() {
        return this.lazyChannelCreation;
    }

    public void setLazyChannelCreation(boolean lazyChannelCreation) {
        this.lazyChannelCreation = lazyChannelCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public boolean isAllowDefaultCodec() {
        return this.allowDefaultCodec;
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
    }

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    private <T> void addToHandlersList(List configured, List handlers, Class<? extends T> handlerType) {
        if (handlers != null) {
            for (int x = 0; x < handlers.size(); ++x) {
                Object handler = handlers.get(x);
                if (!handlerType.isInstance(handler)) continue;
                configured.add(handler);
            }
        }
    }

    public void setClientPipelineFactory(ClientPipelineFactory clientPipelineFactory) {
        this.clientPipelineFactory = clientPipelineFactory;
    }

    public ClientPipelineFactory getClientPipelineFactory() {
        return this.clientPipelineFactory;
    }

    public void setServerPipelineFactory(ServerPipelineFactory serverPipelineFactory) {
        this.serverPipelineFactory = serverPipelineFactory;
    }

    public ServerPipelineFactory getServerPipelineFactory() {
        return this.serverPipelineFactory;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }
}

