/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.util.ExchangeHelper;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(ClientChannelHandler.class);
    private final NettyProducer producer;
    private final Exchange exchange;
    private final AsyncCallback callback;
    private boolean messageReceived;
    private boolean exceptionHandled;

    public ClientChannelHandler(NettyProducer producer, Exchange exchange, AsyncCallback callback) {
        this.producer = producer;
        this.exchange = exchange;
        this.callback = callback;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent channelStateEvent) throws Exception {
        this.producer.getAllChannels().add((Object)channelStateEvent.getChannel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exception caught at Channel: " + ctx.getChannel(), exceptionEvent.getCause());
        }
        if (this.exceptionHandled) {
            return;
        }
        this.exceptionHandled = true;
        Throwable cause = exceptionEvent.getCause();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing channel as an exception was thrown from Netty", cause);
        }
        this.exchange.setException(cause);
        NettyHelper.close(exceptionEvent.getChannel());
        this.callback.done(false);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.trace("Channel closed: {}", (Object)ctx.getChannel());
        if (this.producer.getConfiguration().isSync() && !this.messageReceived && !this.exceptionHandled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel closed but no message received from address: {}", (Object)this.producer.getConfiguration().getAddress());
            }
            this.exchange.setException((Throwable)new CamelExchangeException("No response received from remote server: " + this.producer.getConfiguration().getAddress(), this.exchange));
            this.callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        this.messageReceived = true;
        Object body = messageEvent.getMessage();
        LOG.debug("Message received: {}", body);
        if (this.producer.getConfiguration().isTextline()) {
            try {
                body = this.producer.getContext().getTypeConverter().mandatoryConvertTo(String.class, this.exchange, body);
            }
            catch (NoTypeConversionAvailableException e) {
                this.exchange.setException((Throwable)e);
                this.callback.done(false);
            }
        }
        if (ExchangeHelper.isOutCapable((Exchange)this.exchange)) {
            NettyPayloadHelper.setOut(this.exchange, body);
        } else {
            NettyPayloadHelper.setIn(this.exchange, body);
        }
        try {
            Boolean close = ExchangeHelper.isOutCapable((Exchange)this.exchange) ? (Boolean)this.exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)this.exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
            boolean disconnect = this.producer.getConfiguration().isDisconnect();
            if (close != null) {
                disconnect = close;
            }
            if (disconnect) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing channel when complete at address: {}", (Object)this.producer.getConfiguration().getAddress());
                }
                NettyHelper.close(ctx.getChannel());
            }
        }
        finally {
            this.callback.done(false);
        }
    }
}

