/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ServerChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(ServerChannelHandler.class);
    private NettyConsumer consumer;
    private CamelLogger noReplyLogger;

    public ServerChannelHandler(NettyConsumer consumer) {
        this.consumer = consumer;
        this.noReplyLogger = new CamelLogger(LOG, consumer.getConfiguration().getNoReplyLogLevel());
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.trace("Channel open: {}", (Object)e.getChannel());
        this.consumer.getAllChannels().add((Object)e.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.trace("Channel closed: {}", (Object)e.getChannel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        if (this.consumer.isRunAllowed()) {
            LOG.warn("Closing channel as an exception was thrown from Netty", exceptionEvent.getCause());
            NettyHelper.close(exceptionEvent.getChannel());
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        Object in = messageEvent.getMessage();
        LOG.debug("Incoming message: {}", in);
        Exchange exchange = this.consumer.getEndpoint().createExchange(ctx, messageEvent);
        if (this.consumer.getConfiguration().isSync()) {
            exchange.setPattern(ExchangePattern.InOut);
        }
        if (this.consumer.getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOConverter.normalizeCharset((String)this.consumer.getConfiguration().getCharsetName()));
        }
        try {
            this.consumer.getProcessor().process(exchange);
        }
        catch (Throwable e) {
            this.consumer.getExceptionHandler().handleException(e);
        }
        if (this.consumer.getConfiguration().isSync()) {
            this.sendResponse(messageEvent, exchange);
        }
    }

    private void sendResponse(MessageEvent messageEvent, Exchange exchange) throws Exception {
        Object body = ExchangeHelper.isOutCapable((Exchange)exchange) ? NettyPayloadHelper.getOut(this.consumer.getEndpoint(), exchange) : NettyPayloadHelper.getIn(this.consumer.getEndpoint(), exchange);
        boolean failed = exchange.isFailed();
        if (failed && !this.consumer.getEndpoint().getConfiguration().isTransferExchange()) {
            body = exchange.getException() != null ? exchange.getException() : exchange.getOut().getBody();
        }
        if (body == null) {
            this.noReplyLogger.log("No payload to send as reply for exchange: " + exchange);
            if (this.consumer.getConfiguration().isDisconnectOnNoReply()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing channel as no payload to send as reply at address: {}", (Object)messageEvent.getRemoteAddress());
                }
                NettyHelper.close(messageEvent.getChannel());
            }
        } else {
            if (this.consumer.getConfiguration().isTextline()) {
                body = NettyHelper.getTextlineBody(body, exchange, this.consumer.getConfiguration().getDelimiter(), this.consumer.getConfiguration().isAutoAppendDelimiter());
            }
            LOG.debug("Writing body: {}", body);
            if (this.consumer.getConfiguration().isTcp()) {
                NettyHelper.writeBodySync(messageEvent.getChannel(), null, body, exchange);
            } else {
                NettyHelper.writeBodySync(messageEvent.getChannel(), messageEvent.getRemoteAddress(), body, exchange);
            }
        }
        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
        boolean disconnect = this.consumer.getConfiguration().isDisconnect();
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing channel when complete at address: {}", (Object)messageEvent.getRemoteAddress());
            }
            NettyHelper.close(messageEvent.getChannel());
        }
    }
}

