/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import java.util.Locale;
import org.apache.camel.component.netty4.http.DefaultContextPathMatcher;

public class RestContextPathMatcher
extends DefaultContextPathMatcher {
    private final String rawPath;
    private final String comparePath;

    public RestContextPathMatcher(String rawPath, String path, String restrictMethod, boolean matchOnUriPrefix) {
        super(path, matchOnUriPrefix);
        this.rawPath = rawPath;
        this.comparePath = rawPath + "?" + restrictMethod;
    }

    @Override
    public boolean matchesRest(String path, boolean wildcard) {
        return this.matchRestPath(path, this.rawPath, wildcard);
    }

    @Override
    public boolean matchMethod(String method, String restrict) {
        if (restrict == null) {
            return true;
        }
        if ("OPTIONS".equals(method)) {
            return true;
        }
        return restrict.toLowerCase(Locale.US).contains(method.toLowerCase(Locale.US));
    }

    public boolean matchRestPath(String requestPath, String consumerPath, boolean wildcard) {
        String[] consumerPaths;
        String[] requestPaths;
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.endsWith("/")) {
            requestPath = requestPath.substring(0, requestPath.length() - 1);
        }
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        if ((requestPaths = requestPath.split("/")).length != (consumerPaths = consumerPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < requestPaths.length; ++i) {
            String p1 = requestPaths[i];
            String p2 = consumerPaths[i];
            if (wildcard && p2.startsWith("{") && p2.endsWith("}") || p1.equals(p2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestContextPathMatcher that = (RestContextPathMatcher)o;
        if (this.comparePath.equals(that.comparePath)) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.comparePath.hashCode() + (this.matchOnUriPrefix ? 1 : 0);
    }
}

