/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.handler.codec.http.HttpContent;
import org.apache.camel.CamelException;
import org.apache.camel.util.ObjectHelper;

public class NettyHttpOperationFailedException
extends CamelException {
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String redirectLocation;
    private final int statusCode;
    private final String statusText;
    private final transient HttpContent content;

    public NettyHttpOperationFailedException(String uri, int statusCode, String statusText, String location, HttpContent content) {
        super("Netty HTTP operation failed invoking " + uri + " with statusCode: " + statusCode + (location != null ? ", redirectLocation: " + location : ""));
        this.uri = uri;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.redirectLocation = location;
        this.content = content;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isRedirectError() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean hasRedirectLocation() {
        return ObjectHelper.isNotEmpty((Object)this.redirectLocation);
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public HttpContent getHttpContent() {
        return this.content;
    }
}

