/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty4.NettyConsumer;
import org.apache.camel.component.netty4.NettyConverter;
import org.apache.camel.component.netty4.NettyHelper;
import org.apache.camel.component.netty4.handlers.ServerChannelHandler;
import org.apache.camel.component.netty4.http.HttpPrincipal;
import org.apache.camel.component.netty4.http.NettyHttpConsumer;
import org.apache.camel.component.netty4.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty4.http.SecurityAuthenticator;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerChannelHandler
extends ServerChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpConsumer.class);
    private final NettyHttpConsumer consumer;

    public HttpServerChannelHandler(NettyHttpConsumer consumer) {
        super((NettyConsumer)consumer);
        this.consumer = consumer;
    }

    public NettyHttpConsumer getConsumer() {
        return this.consumer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean isRestrictedToOptions;
        HttpRequest request = (HttpRequest)msg;
        LOG.debug("Message received: {}", (Object)request);
        if (this.consumer.isSuspended()) {
            LOG.debug("Consumer suspended, cannot service request {}", (Object)request);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.channel().close();
            return;
        }
        boolean bl = isRestrictedToOptions = this.consumer.getEndpoint().getHttpMethodRestrict() != null && this.consumer.getEndpoint().getHttpMethodRestrict().contains("OPTIONS");
        if ("OPTIONS".equals(request.getMethod().name()) && !isRestrictedToOptions) {
            String s = this.consumer.getEndpoint().getHttpMethodRestrict() != null ? "OPTIONS," + this.consumer.getEndpoint().getHttpMethodRestrict() : "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set("Allow", (Object)s);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            return;
        }
        if (this.consumer.getEndpoint().getHttpMethodRestrict() != null && !this.consumer.getEndpoint().getHttpMethodRestrict().contains(request.getMethod().name())) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.channel().close();
            return;
        }
        if ("TRACE".equals(request.getMethod().name()) && !this.consumer.getEndpoint().isTraceEnabled()) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.channel().close();
            return;
        }
        if (!request.headers().contains("Host")) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.channel().close();
            return;
        }
        NettyHttpSecurityConfiguration security = this.consumer.getEndpoint().getSecurityConfiguration();
        if (security != null && security.isAuthenticate() && "Basic".equalsIgnoreCase(security.getConstraint())) {
            String roles;
            String url = request.getUri();
            if (url.contains("?")) {
                url = ObjectHelper.before((String)url, (String)"?");
            }
            URI uri = new URI(request.getUri());
            String target = uri.getPath();
            String path = this.consumer.getConfiguration().getPath();
            if (path != null && target.startsWith(path)) {
                target = target.substring(path.length());
            }
            if ((roles = security.getSecurityConstraint() != null ? security.getSecurityConstraint().restricted(target) : "*") != null) {
                HttpPrincipal principal = HttpServerChannelHandler.extractBasicAuthSubject(request);
                Subject subject = null;
                boolean inRole = true;
                if (principal != null && (subject = this.authenticate(security.getSecurityAuthenticator(), security.getLoginDeniedLoggingLevel(), principal)) != null) {
                    String userRoles = security.getSecurityAuthenticator().getUserRoles(subject);
                    inRole = this.matchesRoles(roles, userRoles);
                }
                if (principal == null || subject == null || !inRole) {
                    if (principal == null) {
                        LOG.debug("Http Basic Auth required for resource: {}", (Object)url);
                    } else if (subject == null) {
                        LOG.debug("Http Basic Auth not authorized for username: {}", (Object)principal.getUsername());
                    } else {
                        LOG.debug("Http Basic Auth not in role for username: {}", (Object)principal.getUsername());
                    }
                    DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                    response.headers().set("WWW-Authenticate", (Object)("Basic realm=\"" + security.getRealm() + "\""));
                    response.headers().set("Content-Type", (Object)"text/plain");
                    response.headers().set("Content-Length", (Object)0);
                    ctx.writeAndFlush((Object)response);
                    ctx.channel().close();
                    return;
                }
                LOG.debug("Http Basic Auth authorized for username: {}", (Object)principal.getUsername());
            }
        }
        super.channelRead0(ctx, msg);
    }

    protected boolean matchesRoles(String roles, String userRoles) {
        if (roles.equals("*")) {
            return true;
        }
        Iterator it = ObjectHelper.createIterator((Object)userRoles);
        while (it.hasNext()) {
            String userRole = it.next().toString();
            if (!roles.contains(userRole)) continue;
            return true;
        }
        return false;
    }

    protected static HttpPrincipal extractBasicAuthSubject(HttpRequest request) {
        String constraint;
        String auth = request.headers().get("Authorization");
        if (auth != null && (constraint = ObjectHelper.before((String)auth, (String)" ")) != null && "Basic".equalsIgnoreCase(constraint.trim())) {
            String decoded = ObjectHelper.after((String)auth, (String)" ");
            ByteBuf buf = NettyConverter.toByteBuffer((byte[])decoded.getBytes());
            ByteBuf out = Base64.decode((ByteBuf)buf);
            String userAndPw = out.toString(Charset.defaultCharset());
            String username = ObjectHelper.before((String)userAndPw, (String)":");
            String password = ObjectHelper.after((String)userAndPw, (String)":");
            HttpPrincipal principal = new HttpPrincipal(username, password);
            LOG.debug("Extracted Basic Auth principal from HTTP header: {}", (Object)principal);
            return principal;
        }
        return null;
    }

    protected Subject authenticate(SecurityAuthenticator authenticator, LoggingLevel deniedLoggingLevel, HttpPrincipal principal) {
        try {
            return authenticator.login(principal);
        }
        catch (LoginException e) {
            CamelLogger logger = new CamelLogger(LOG, deniedLoggingLevel);
            logger.log("Cannot login " + principal.getName() + " due " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void beforeProcess(Exchange exchange, ChannelHandlerContext ctx, Object message) {
        HttpRequest request;
        boolean keepAlive;
        if (this.consumer.getConfiguration().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
        }
        if (!(keepAlive = HttpHeaders.isKeepAlive((HttpMessage)(request = (HttpRequest)message)))) {
            exchange.setProperty("Connection", (Object)"close");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.consumer.isRunAllowed()) {
            if (cause instanceof ClosedChannelException) {
                LOG.debug("Channel already closed. Ignoring this exception.");
            } else {
                LOG.debug("Closing channel as an exception was thrown from Netty", cause);
                NettyHelper.close((Channel)ctx.channel());
            }
        }
    }

    protected Object getResponseBody(Exchange exchange) throws Exception {
        if (exchange.hasOut()) {
            return this.consumer.getEndpoint().getNettyHttpBinding().toNettyResponse(exchange.getOut(), this.consumer.getConfiguration());
        }
        return this.consumer.getEndpoint().getNettyHttpBinding().toNettyResponse(exchange.getIn(), this.consumer.getConfiguration());
    }
}

