/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.io.BufferedInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

public class OsgiComponentResolver
implements ComponentResolver {
    private static final transient Log LOG = LogFactory.getLog(OsgiComponentResolver.class);
    private BundleContext bundleContext;
    private Map<String, ComponentEntry> components;

    public OsgiComponentResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void init() {
        if (this.components != null) {
            return;
        }
        LOG.debug((Object)"Initializing OsgiComponentResolver");
        this.components = new HashMap<String, ComponentEntry>();
        this.bundleContext.addBundleListener((org.osgi.framework.BundleListener)new BundleListener());
        Bundle[] previousBundles = this.bundleContext.getBundles();
        for (int i = 0; i < previousBundles.length; ++i) {
            int state = previousBundles[i].getState();
            if (state != 4 && state != 32) continue;
            try {
                this.mayBeAddComponentFor(previousBundles[i]);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Component " + previousBundles[i] + " not added due to " + e.toString()), (Throwable)e);
            }
        }
    }

    protected synchronized void mayBeAddComponentFor(Bundle bundle) {
        Enumeration e = bundle.getEntryPaths("/META-INF/services/org/apache/camel/component/");
        if (e != null) {
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found entry: " + path + " in bundle " + bundle.getSymbolicName()));
                }
                ComponentEntry entry = new ComponentEntry();
                entry.bundle = bundle;
                entry.path = path;
                entry.name = path.substring(path.lastIndexOf("/") + 1);
                this.components.put(entry.name, entry);
            }
        }
    }

    protected synchronized void mayBeRemoveComponentFor(Bundle bundle) {
        for (ComponentEntry entry : this.components.values()) {
            if (entry.bundle != bundle) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing entry: " + entry.path + " in bundle " + bundle.getSymbolicName()));
            }
            this.components.remove(entry.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class getComponent(String name) throws Exception {
        ComponentEntry entry = this.components.get(name);
        if (entry == null) {
            return null;
        }
        if (entry.type == null) {
            URL url = entry.bundle.getEntry(entry.path);
            Properties properties = new Properties();
            BufferedInputStream reader = null;
            try {
                reader = new BufferedInputStream(url.openStream());
                properties.load(reader);
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception ignore) {}
            }
            String classname = (String)properties.get("class");
            BundleDelegatingClassLoader loader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)entry.bundle);
            entry.type = loader.loadClass(classname);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found component: " + name + " via type: " + entry.type.getName()));
        }
        return entry.type;
    }

    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Object bean = null;
        try {
            bean = context.getRegistry().lookup(name);
            if (bean != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found component: " + name + " in registry: " + bean));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
        }
        if (bean != null && bean instanceof Component) {
            return (Component)bean;
        }
        this.init();
        Class type = null;
        try {
            type = this.getComponent(name);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid URI, no Component registered for scheme : " + name, e);
        }
        if (type == null) {
            return null;
        }
        if (Component.class.isAssignableFrom(type)) {
            return (Component)context.getInjector().newInstance(type);
        }
        throw new IllegalArgumentException("Type is not a Component implementation. Found: " + type.getName());
    }

    private class ComponentEntry {
        Bundle bundle;
        String path;
        String name;
        Class type;

        private ComponentEntry() {
        }
    }

    private class BundleListener
    implements SynchronousBundleListener {
        private BundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            try {
                Bundle bundle = event.getBundle();
                if (event.getType() == 32) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Bundle resolved: " + bundle.getSymbolicName()));
                    }
                    OsgiComponentResolver.this.mayBeAddComponentFor(bundle);
                } else if (event.getType() == 64) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Bundle unresolved: " + bundle.getSymbolicName()));
                    }
                    OsgiComponentResolver.this.mayBeRemoveComponentFor(bundle);
                }
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Exception handing bundle changed event", e);
            }
        }
    }
}

