/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.util.Set;
import org.apache.camel.Converter;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.TypeConverterRegistry;
import org.apache.camel.osgi.Activator;
import org.apache.camel.osgi.OsgiResolverUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResolverUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class OsgiAnnotationTypeConverterLoader
extends AnnotationTypeConverterLoader {
    private static final transient Log LOG = LogFactory.getLog(OsgiAnnotationTypeConverterLoader.class);

    public OsgiAnnotationTypeConverterLoader(BundleContext context) {
        super((ResolverUtil)new OsgiResolverUtil(context));
    }

    public void load(TypeConverterRegistry registry) throws Exception {
        for (Activator.TypeConverterEntry entry : Activator.getTypeConverterEntries()) {
            OsgiResolverUtil resolver = new OsgiResolverUtil(entry.bundle);
            String[] packages = entry.converterPackages.toArray(new String[entry.converterPackages.size()]);
            resolver.findAnnotated(Converter.class, packages);
            Set classes = resolver.getClasses();
            for (Class type : classes) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading converter class: " + ObjectHelper.name((Class)type)));
                }
                this.loadConverterMethods(registry, type);
            }
        }
    }
}

