/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.camel.osgi.Activator;
import org.apache.camel.util.FactoryFinder;
import org.apache.camel.util.NoFactoryAvailableException;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OsgiFactoryFinder
extends FactoryFinder {
    public OsgiFactoryFinder() {
    }

    public OsgiFactoryFinder(String path) {
        super(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String key, String propertyPrefix) throws ClassNotFoundException, IOException {
        if (propertyPrefix == null) {
            propertyPrefix = "";
        }
        Class clazz = (Class)this.classMap.get(propertyPrefix + key);
        Properties properties = null;
        if (clazz == null) {
            BundleEntry entry = this.getResource(key);
            if (entry != null) {
                URL url = entry.url;
                InputStream in = url.openStream();
                BufferedInputStream reader = null;
                try {
                    reader = new BufferedInputStream(in);
                    properties = new Properties();
                    properties.load(reader);
                    String className = properties.getProperty(propertyPrefix + "class");
                    if (className == null) {
                        throw new IOException("Expected property is missing: " + propertyPrefix + "class");
                    }
                    clazz = entry.bundle.loadClass(className);
                    this.classMap.put(propertyPrefix + key, clazz);
                }
                finally {
                    ObjectHelper.close((Closeable)reader, (String)key, null);
                    ObjectHelper.close((Closeable)in, (String)key, null);
                }
            } else {
                throw new NoFactoryAvailableException(propertyPrefix + key);
            }
        }
        return clazz;
    }

    public BundleEntry getResource(String name) {
        URL url = null;
        BundleEntry entry = null;
        Bundle[] bundles = null;
        BundleContext bundleContext = Activator.getBundle().getBundleContext();
        bundles = bundleContext == null ? new Bundle[]{Activator.getBundle()} : bundleContext.getBundles();
        for (Bundle bundle : bundles) {
            url = bundle.getEntry(this.getPath() + name);
            if (url == null) continue;
            entry = new BundleEntry();
            entry.url = url;
            entry.bundle = bundle;
            break;
        }
        return entry;
    }

    private class BundleEntry {
        URL url;
        Bundle bundle;

        private BundleEntry() {
        }
    }
}

