/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pgevent;

import com.impossibl.postgres.api.jdbc.PGConnection;
import java.sql.SQLException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.pgevent.InvalidStateException;
import org.apache.camel.component.pgevent.PgEventEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;

public class PgEventProducer
extends DefaultAsyncProducer {
    private final PgEventEndpoint endpoint;
    private PGConnection dbConnection;

    public PgEventProducer(PgEventEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.dbConnection.isClosed()) {
                this.dbConnection = this.endpoint.initJdbc();
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)new InvalidStateException("Database connection closed and could not be re-opened.", e));
            callback.done(true);
            return true;
        }
        try {
            this.dbConnection.createStatement().execute("NOTIFY " + this.endpoint.getChannel() + ", '" + (String)exchange.getIn().getBody(String.class) + "'");
        }
        catch (SQLException e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.dbConnection = this.endpoint.initJdbc();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.dbConnection != null) {
            this.dbConnection.close();
        }
    }
}

