/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.printer;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.Sides;
import org.apache.camel.component.printer.PrinterOperationsInterface;
import org.apache.camel.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrinterOperations
implements PrinterOperationsInterface {
    private static final transient Log LOG = LogFactory.getLog(PrinterOperations.class);
    private PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
    private DocPrintJob job;
    private DocFlavor flavor;
    private PrintRequestAttributeSet printRequestAttributeSet;
    private Doc doc;

    public PrinterOperations() throws PrintException {
        if (this.printService == null) {
            throw new PrintException("Printer lookup failure. No default printer set up for this host");
        }
        this.job = this.printService.createPrintJob();
        this.flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        this.printRequestAttributeSet = new HashPrintRequestAttributeSet();
        this.printRequestAttributeSet.add(new Copies(1));
        this.printRequestAttributeSet.add(MediaSizeName.NA_LETTER);
        this.printRequestAttributeSet.add(Sides.ONE_SIDED);
    }

    public PrinterOperations(PrintService printService, DocPrintJob job, DocFlavor flavor, PrintRequestAttributeSet printRequestAttributeSet) throws PrintException {
        this();
        this.setPrintService(printService);
        this.setJob(job);
        this.setFlavor(flavor);
        this.setPrintRequestAttributeSet(printRequestAttributeSet);
    }

    public void print(Doc doc, int copies, boolean sendToPrinter, String mimeType) throws PrintException {
        LOG.trace((Object)("Print Service: " + this.printService.getName()));
        LOG.trace((Object)("About to print " + copies + " copy(s)"));
        for (int i = 0; i < copies; ++i) {
            if (!sendToPrinter) {
                LOG.debug((Object)"Print flag is set to false. This job will not be printed until this setting remains in effect. Please set the flag to true or remove the setting.");
                File file = mimeType.equalsIgnoreCase("GIF") || mimeType.equalsIgnoreCase("RENDERABLE_IMAGE") ? new File("./target/TestPrintJobNo" + i + "_" + UUID.randomUUID() + ".gif") : (mimeType.equalsIgnoreCase("JPEG") ? new File("./target/TestPrintJobNo" + i + "_" + UUID.randomUUID() + ".jpeg") : (mimeType.equalsIgnoreCase("PDF") ? new File("./target/TestPrintJobNo" + i + "_" + UUID.randomUUID() + ".pdf") : new File("./target/TestPrintJobNo" + i + "_" + UUID.randomUUID() + ".txt")));
                LOG.debug((Object)("Writing print job to file: " + file.getAbsolutePath()));
                try {
                    InputStream in = doc.getStreamForBytes();
                    FileOutputStream fos = new FileOutputStream(file);
                    IOHelper.copyAndCloseInput((InputStream)in, (OutputStream)fos);
                    IOHelper.close((Closeable)fos);
                    continue;
                }
                catch (Exception e) {
                    throw new PrintException("Error writing Document to the target file " + file.getAbsolutePath());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Issuing Job " + i + " to Printer: " + this.printService.getName()));
            }
            this.print(doc);
        }
    }

    public void print(Doc doc) throws PrintException {
        this.job.print(doc, this.printRequestAttributeSet);
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public DocPrintJob getJob() {
        return this.job;
    }

    public void setJob(DocPrintJob job) {
        this.job = job;
    }

    public DocFlavor getFlavor() {
        return this.flavor;
    }

    public void setFlavor(DocFlavor flavor) {
        this.flavor = flavor;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printRequestAttributeSet;
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        this.printRequestAttributeSet = printRequestAttributeSet;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }
}

