/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.protobuf;

import com.google.protobuf.Message;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

public class ProtobufDataFormat
implements DataFormat {
    private Message defaultInstance;
    private String instanceClassName;

    public ProtobufDataFormat(Message defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    public ProtobufDataFormat() {
    }

    public void setDefaultInstace(Message instance) {
        this.defaultInstance = instance;
    }

    public void setDefaultInstance(Object instance) {
        if (!(instance instanceof Message)) {
            throw new IllegalArgumentException("The argument for setDefaultInstance should be subClass of com.google.protobuf.Message");
        }
        this.defaultInstance = (Message)instance;
    }

    public synchronized Message getInstance(Exchange exchange) throws Exception {
        if (this.defaultInstance == null) {
            if (this.instanceClassName == null) {
                throw new CamelException("There is not defaultInstance for protobuf unmarshaling");
            }
            if (this.defaultInstance == null) {
                this.defaultInstance = this.loadDefaultInstance(this.instanceClassName, exchange.getContext());
            }
        }
        return this.defaultInstance;
    }

    public void setInstanceClass(String className) throws Exception {
        ObjectHelper.notNull((Object)className, (String)"ProtobufDataFormat instaceClass");
        this.instanceClassName = className;
    }

    protected Message loadDefaultInstance(String className, CamelContext context) throws CamelException, ClassNotFoundException {
        Class instanceClass = context.getClassResolver().resolveMandatoryClass(className);
        if (Message.class.isAssignableFrom(instanceClass)) {
            try {
                Method method = instanceClass.getMethod("getDefaultInstance", new Class[0]);
                return (Message)method.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                throw new CamelException("Can't set the defaultInstance of ProtobufferDataFormat with " + className + ", caused by " + ex);
            }
        }
        throw new CamelException("Can't set the defaultInstance of ProtobufferDataFormat with " + className + ", as the class is not a subClass of com.google.protobuf.Message");
    }

    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        ((Message)graph).writeTo(outputStream);
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Message instance = this.getInstance(exchange);
        Message.Builder builder = instance.newBuilderForType().mergeFrom(inputStream);
        if (!builder.isInitialized()) {
            throw new InvalidPayloadException(exchange, instance.getClass());
        }
        return builder.build();
    }
}

