/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.routepolicy.quartz.ScheduledJob;
import org.apache.camel.routepolicy.quartz.ScheduledJobState;
import org.apache.camel.routepolicy.quartz.ScheduledRouteDetails;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicyConstants;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledRoutePolicy
extends RoutePolicySupport
implements ScheduledRoutePolicyConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledRoutePolicy.class);
    protected Map<String, ScheduledRouteDetails> scheduledRouteDetailsMap = new LinkedHashMap<String, ScheduledRouteDetails>();
    private Scheduler scheduler;
    private int routeStopGracePeriod;
    private TimeUnit timeUnit;

    protected abstract Trigger createTrigger(ScheduledRoutePolicyConstants.Action var1, Route var2) throws Exception;

    protected void onJobExecute(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        LOG.debug("Scheduled Event notification received. Performing action: {} on route: {}", (Object)action, (Object)route.getId());
        ServiceStatus routeStatus = route.getRouteContext().getCamelContext().getRouteStatus(route.getId());
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            if (routeStatus == ServiceStatus.Stopped) {
                this.startRoute(route);
            } else if (ServiceHelper.isSuspended((Object)route.getConsumer())) {
                this.startConsumer(route.getConsumer());
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            if (routeStatus == ServiceStatus.Started || routeStatus == ServiceStatus.Suspended) {
                this.stopRoute(route, this.getRouteStopGracePeriod(), this.getTimeUnit());
            } else {
                LOG.warn("Route is not in a started/suspended state and cannot be stopped. The current route state is {}", (Object)routeStatus);
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            if (routeStatus == ServiceStatus.Started) {
                this.stopConsumer(route.getConsumer());
            } else {
                LOG.warn("Route is not in a started state and cannot be suspended. The current route state is {}", (Object)routeStatus);
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            if (routeStatus == ServiceStatus.Started) {
                if (ServiceHelper.isSuspended((Object)route.getConsumer())) {
                    this.startConsumer(route.getConsumer());
                } else {
                    LOG.warn("The Consumer {} is not suspended and cannot be resumed.", (Object)route.getConsumer());
                }
            } else {
                LOG.warn("Route is not in a started state and cannot be resumed. The current route state is {}", (Object)routeStatus);
            }
        }
    }

    public void onRemove(Route route) {
        try {
            this.doStop();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void scheduleRoute(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        JobDetail existingJobDetail;
        JobDetail jobDetail = this.createJobDetail(action, route);
        Trigger trigger = this.createTrigger(action, route);
        this.updateScheduledRouteDetails(action, jobDetail, trigger, route);
        this.loadCallbackDataIntoSchedulerContext(jobDetail, action, route);
        boolean isClustered = ((QuartzComponent)route.getRouteContext().getCamelContext().getComponent("quartz", QuartzComponent.class)).isClustered();
        if (isClustered && jobDetail.equals((Object)(existingJobDetail = this.getScheduler().getJobDetail(jobDetail.getName(), jobDetail.getGroup())))) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Skipping to schedule the job: {} for action: {} on route {} as the job: {} already existing inside the cluster", new Object[]{jobDetail.getFullName(), action, route.getId(), existingJobDetail.getFullName()});
            }
            return;
        }
        this.getScheduler().scheduleJob(jobDetail, trigger);
        if (LOG.isInfoEnabled()) {
            LOG.info("Scheduled trigger: {} for action: {} on route {}", new Object[]{trigger.getFullName(), action, route.getId()});
        }
    }

    public void pauseRouteTrigger(ScheduledRoutePolicyConstants.Action action, String routeId) throws SchedulerException {
        String triggerName = this.retrieveTriggerName(action, routeId);
        String triggerGroup = this.retrieveTriggerGroup(action, routeId);
        this.getScheduler().pauseTrigger(triggerName, triggerGroup);
        LOG.debug("Scheduled trigger: {}.{} is paused", (Object)triggerGroup, (Object)triggerName);
    }

    public void resumeRouteTrigger(ScheduledRoutePolicyConstants.Action action, String routeId) throws SchedulerException {
        String triggerName = this.retrieveTriggerName(action, routeId);
        String triggerGroup = this.retrieveTriggerGroup(action, routeId);
        this.getScheduler().resumeTrigger(triggerName, triggerGroup);
        LOG.debug("Scheduled trigger: {}.{} is resumed", (Object)triggerGroup, (Object)triggerName);
    }

    protected void doStop() throws Exception {
        for (ScheduledRouteDetails scheduledRouteDetails : this.scheduledRouteDetailsMap.values()) {
            if (scheduledRouteDetails.getStartJobDetail() != null) {
                this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.START, scheduledRouteDetails);
            }
            if (scheduledRouteDetails.getStopJobDetail() != null) {
                this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.STOP, scheduledRouteDetails);
            }
            if (scheduledRouteDetails.getSuspendJobDetail() != null) {
                this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.SUSPEND, scheduledRouteDetails);
            }
            if (scheduledRouteDetails.getResumeJobDetail() == null) continue;
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.RESUME, scheduledRouteDetails);
        }
    }

    public void deleteRouteJob(ScheduledRoutePolicyConstants.Action action, ScheduledRouteDetails scheduledRouteDetails) throws SchedulerException {
        String jobDetailName = this.retrieveJobDetailName(action, scheduledRouteDetails);
        String jobDetailGroup = this.retrieveJobDetailGroup(action, scheduledRouteDetails);
        if (!this.getScheduler().isShutdown()) {
            this.getScheduler().deleteJob(jobDetailName, jobDetailGroup);
        }
        LOG.debug("Scheduled job: {}.{} is deleted", (Object)jobDetailGroup, (Object)jobDetailName);
    }

    protected JobDetail createJobDetail(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        JobDetail jobDetail = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            jobDetail = new JobDetail(JOB_START + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            jobDetail = new JobDetail(JOB_STOP + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            jobDetail = new JobDetail(JOB_SUSPEND + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            jobDetail = new JobDetail(JOB_RESUME + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        }
        return jobDetail;
    }

    protected void updateScheduledRouteDetails(ScheduledRoutePolicyConstants.Action action, JobDetail jobDetail, Trigger trigger, Route route) throws Exception {
        ScheduledRouteDetails scheduledRouteDetails = this.getScheduledRouteDetails(route.getId());
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            scheduledRouteDetails.setStartJobDetail(jobDetail);
            scheduledRouteDetails.setStartTrigger(trigger);
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            scheduledRouteDetails.setStopJobDetail(jobDetail);
            scheduledRouteDetails.setStopTrigger(trigger);
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            scheduledRouteDetails.setSuspendJobDetail(jobDetail);
            scheduledRouteDetails.setSuspendTrigger(trigger);
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            scheduledRouteDetails.setResumeJobDetail(jobDetail);
            scheduledRouteDetails.setResumeTrigger(trigger);
        }
    }

    protected void loadCallbackDataIntoSchedulerContext(JobDetail jobDetail, ScheduledRoutePolicyConstants.Action action, Route route) throws SchedulerException {
        this.getScheduler().getContext().put((Object)jobDetail.getName(), (Object)new ScheduledJobState(action, route));
    }

    public String retrieveTriggerName(ScheduledRoutePolicyConstants.Action action, String routeId) {
        ScheduledRouteDetails scheduledRouteDetails = this.getScheduledRouteDetails(routeId);
        String triggerName = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            triggerName = scheduledRouteDetails.getStartTrigger().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            triggerName = scheduledRouteDetails.getStopTrigger().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            triggerName = scheduledRouteDetails.getSuspendTrigger().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            triggerName = scheduledRouteDetails.getResumeTrigger().getName();
        }
        return triggerName;
    }

    public String retrieveTriggerGroup(ScheduledRoutePolicyConstants.Action action, String routeId) {
        ScheduledRouteDetails scheduledRouteDetails = this.getScheduledRouteDetails(routeId);
        String triggerGroup = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            triggerGroup = scheduledRouteDetails.getStartTrigger().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            triggerGroup = scheduledRouteDetails.getStopTrigger().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            triggerGroup = scheduledRouteDetails.getSuspendTrigger().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            triggerGroup = scheduledRouteDetails.getResumeTrigger().getGroup();
        }
        return triggerGroup;
    }

    public String retrieveJobDetailName(ScheduledRoutePolicyConstants.Action action, ScheduledRouteDetails scheduledRouteDetails) {
        String jobDetailName = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            jobDetailName = scheduledRouteDetails.getStartJobDetail().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            jobDetailName = scheduledRouteDetails.getStopJobDetail().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            jobDetailName = scheduledRouteDetails.getSuspendJobDetail().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            jobDetailName = scheduledRouteDetails.getResumeJobDetail().getName();
        }
        return jobDetailName;
    }

    public String retrieveJobDetailGroup(ScheduledRoutePolicyConstants.Action action, ScheduledRouteDetails scheduledRouteDetails) {
        String jobDetailGroup = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            jobDetailGroup = scheduledRouteDetails.getStartJobDetail().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            jobDetailGroup = scheduledRouteDetails.getStopJobDetail().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            jobDetailGroup = scheduledRouteDetails.getSuspendJobDetail().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            jobDetailGroup = scheduledRouteDetails.getResumeJobDetail().getGroup();
        }
        return jobDetailGroup;
    }

    protected void registerRouteToScheduledRouteDetails(Route route) {
        ScheduledRouteDetails scheduledRouteDetails = new ScheduledRouteDetails();
        this.scheduledRouteDetailsMap.put(route.getId(), scheduledRouteDetails);
    }

    protected ScheduledRouteDetails getScheduledRouteDetails(String routeId) {
        return this.scheduledRouteDetailsMap.get(routeId);
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setRouteStopGracePeriod(int routeStopGracePeriod) {
        this.routeStopGracePeriod = routeStopGracePeriod;
    }

    public int getRouteStopGracePeriod() {
        return this.routeStopGracePeriod;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

