/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.StartupListener;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzComponent
extends DefaultComponent
implements StartupListener {
    private static final transient Log LOG = LogFactory.getLog(QuartzComponent.class);
    private final AtomicInteger jobs = new AtomicInteger();
    private Scheduler scheduler;
    private final List<JobToAdd> jobsToAdd = new ArrayList<JobToAdd>();
    private SchedulerFactory factory;
    private Properties properties;
    private String propertiesFile;
    private int startDelayedSeconds;
    private boolean autoStartScheduler = true;

    public QuartzComponent() {
    }

    public QuartzComponent(CamelContext context) {
        super(context);
    }

    protected QuartzEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CronTrigger trigger;
        String name;
        String group;
        URI u = new URI(uri);
        String path = ObjectHelper.after((String)u.getPath(), (String)"/");
        String host = u.getHost();
        String cron = (String)this.getAndRemoveParameter(parameters, "cron", String.class);
        Boolean fireNow = (Boolean)this.getAndRemoveParameter(parameters, "fireNow", Boolean.class, Boolean.FALSE);
        if (ObjectHelper.isNotEmpty((Object)path) && ObjectHelper.isNotEmpty((Object)host)) {
            group = host;
            name = path;
        } else {
            group = "Camel";
            name = host;
        }
        Map triggerParameters = IntrospectionSupport.extractProperties(parameters, (String)"trigger.");
        Map jobParameters = IntrospectionSupport.extractProperties(parameters, (String)"job.");
        boolean stateful = "true".equals(parameters.get("stateful"));
        if (!this.isClustered() && !stateful && (trigger = this.getScheduler().getTrigger(name, group)) != null) {
            String msg = "A Quartz job already exists with the name/group: " + name + "/" + group;
            throw new IllegalArgumentException(msg);
        }
        if (ObjectHelper.isNotEmpty((Object)cron)) {
            trigger = this.createCronTrigger(cron);
        } else {
            String intervalString;
            trigger = new SimpleTrigger();
            if (fireNow.booleanValue() && (intervalString = (String)triggerParameters.get("repeatInterval")) != null) {
                long interval = Long.valueOf(intervalString);
                trigger.setStartTime(new Date(System.currentTimeMillis() - interval));
            }
        }
        QuartzEndpoint answer = new QuartzEndpoint(uri, this);
        this.setProperties(answer.getJobDetail(), jobParameters);
        this.setProperties(trigger, triggerParameters);
        trigger.setName(name);
        trigger.setGroup(group);
        answer.setTrigger((Trigger)trigger);
        return answer;
    }

    protected CronTrigger createCronTrigger(String path) throws ParseException {
        path = path.replaceAll("\\+", " ");
        CronTrigger cron = new CronTrigger();
        cron.setCronExpression(path);
        return cron;
    }

    public void onCamelContextStarted(CamelContext camelContext, boolean alreadyStarted) throws Exception {
        if (this.scheduler != null) {
            this.scheduler.getContext().put((Object)("CamelQuartzCamelContext-" + this.getCamelContext().getName()), (Object)this.getCamelContext());
        }
        if (!this.isAutoStartScheduler()) {
            LOG.info((Object)"QuartzComponent configured to not auto start Quartz scheduler.");
            return;
        }
        this.startScheduler();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduler == null) {
            this.scheduler = this.getScheduler();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scheduler != null) {
            int number = this.jobs.get();
            if (number > 0) {
                LOG.info((Object)("Cannot shutdown Quartz scheduler: " + this.scheduler.getSchedulerName() + " as there are still " + number + " jobs registered."));
            } else {
                LOG.info((Object)("There are no more jobs registered, so shutting down Quartz scheduler: " + this.scheduler.getSchedulerName()));
                this.scheduler.shutdown();
                this.scheduler = null;
            }
        }
    }

    public void addJob(JobDetail job, Trigger trigger) throws SchedulerException {
        if (this.scheduler == null) {
            this.jobsToAdd.add(new JobToAdd(job, trigger));
        } else {
            this.doAddJob(job, trigger);
        }
    }

    private void doAddJob(JobDetail job, Trigger trigger) throws SchedulerException {
        this.jobs.incrementAndGet();
        Trigger existingTrigger = this.getScheduler().getTrigger(trigger.getName(), trigger.getGroup());
        if (existingTrigger == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding job using trigger: " + trigger.getGroup() + "/" + trigger.getName()));
            }
            this.getScheduler().scheduleJob(job, trigger);
        } else if (this.hasTriggerChanged(existingTrigger, trigger)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trigger: " + trigger.getGroup() + "/" + trigger.getName() + " already exists and will be updated by Quartz."));
            }
            this.scheduler.addJob(job, true);
            trigger.setJobName(job.getName());
            this.scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trigger: " + trigger.getGroup() + "/" + trigger.getName() + " already exists and will be resumed automatically by Quartz."));
            }
            if (!this.isClustered()) {
                this.scheduler.resumeTrigger(trigger.getName(), trigger.getGroup());
            }
        }
    }

    private boolean hasTriggerChanged(Trigger oldTrigger, Trigger newTrigger) {
        if (oldTrigger instanceof CronTrigger && oldTrigger.equals((Object)newTrigger)) {
            CronTrigger oldCron = (CronTrigger)oldTrigger;
            CronTrigger newCron = (CronTrigger)newTrigger;
            return !oldCron.getCronExpression().equals(newCron.getCronExpression());
        }
        return !newTrigger.equals((Object)oldTrigger);
    }

    public void pauseJob(Trigger trigger) throws SchedulerException {
        this.jobs.decrementAndGet();
        if (this.isClustered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot pause job using trigger: " + trigger.getGroup() + "/" + trigger.getName() + " as the JobStore is clustered."));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pausing job using trigger: " + trigger.getGroup() + "/" + trigger.getName()));
            }
            this.getScheduler().pauseTrigger(trigger.getName(), trigger.getGroup());
            this.getScheduler().pauseJob(trigger.getName(), trigger.getGroup());
        }
    }

    public void deleteJob(String name, String group) throws SchedulerException {
        if (this.isClustered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot delete job using trigger: " + group + "/" + name + " as the JobStore is clustered."));
            }
        } else {
            Trigger trigger = this.getScheduler().getTrigger(name, group);
            if (trigger != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deleting job using trigger: " + group + "/" + name));
                }
                this.getScheduler().unscheduleJob(name, group);
            }
        }
    }

    public void shutdownScheduler() throws SchedulerException {
        if (this.scheduler != null) {
            LOG.info((Object)("Forcing shutdown of Quartz scheduler: " + this.scheduler.getSchedulerName()));
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    public boolean isClustered() throws SchedulerException {
        try {
            return this.getScheduler().getMetaData().isJobStoreClustered();
        }
        catch (NoSuchMethodError e) {
            LOG.debug((Object)"Job clustering is only supported since Quartz 1.7, isClustered returning false");
            return false;
        }
    }

    public void startScheduler() throws SchedulerException {
        for (JobToAdd add : this.jobsToAdd) {
            this.doAddJob(add.getJob(), add.getTrigger());
        }
        this.jobsToAdd.clear();
        if (!this.getScheduler().isStarted()) {
            if (this.getStartDelayedSeconds() > 0) {
                LOG.info((Object)("Starting Quartz scheduler: " + this.getScheduler().getSchedulerName() + " delayed: " + this.getStartDelayedSeconds() + " seconds."));
                try {
                    this.getScheduler().startDelayed(this.getStartDelayedSeconds());
                }
                catch (NoSuchMethodError e) {
                    LOG.warn((Object)("Your version of Quartz is too old to support delayed startup! Starting Quartz scheduler immediately : " + this.getScheduler().getSchedulerName()));
                    this.getScheduler().start();
                }
            } else {
                LOG.info((Object)("Starting Quartz scheduler: " + this.getScheduler().getSchedulerName()));
                this.getScheduler().start();
            }
        }
    }

    public SchedulerFactory getFactory() throws SchedulerException {
        if (this.factory == null) {
            this.factory = this.createSchedulerFactory();
        }
        return this.factory;
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public synchronized Scheduler getScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            this.scheduler = this.createScheduler();
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public int getStartDelayedSeconds() {
        return this.startDelayedSeconds;
    }

    public void setStartDelayedSeconds(int startDelayedSeconds) {
        this.startDelayedSeconds = startDelayedSeconds;
    }

    public boolean isAutoStartScheduler() {
        return this.autoStartScheduler;
    }

    public void setAutoStartScheduler(boolean autoStartScheduler) {
        this.autoStartScheduler = autoStartScheduler;
    }

    protected Properties loadProperties() throws SchedulerException {
        Properties answer = this.getProperties();
        if (answer == null && this.getPropertiesFile() != null) {
            InputStream is;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Loading Quartz properties file from classpath: " + this.getPropertiesFile()));
            }
            if ((is = this.getCamelContext().getClassResolver().loadResourceAsStream(this.getPropertiesFile())) == null) {
                throw new SchedulerException("Quartz properties file not found in classpath: " + this.getPropertiesFile());
            }
            answer = new Properties();
            try {
                answer.load(is);
            }
            catch (IOException e) {
                throw new SchedulerException("Error loading Quartz properties file from classpath: " + this.getPropertiesFile(), (Throwable)e);
            }
        }
        return answer;
    }

    protected SchedulerFactory createSchedulerFactory() throws SchedulerException {
        StdSchedulerFactory answer;
        Properties prop = this.loadProperties();
        if (prop != null) {
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            answer = new StdSchedulerFactory(prop);
        } else {
            InputStream is = StdSchedulerFactory.class.getClassLoader().getResourceAsStream("org/quartz/quartz.properties");
            if (is == null) {
                throw new SchedulerException("Quartz properties file not found in classpath: org/quartz/quartz.properties");
            }
            prop = new Properties();
            try {
                prop.load(is);
            }
            catch (IOException e) {
                throw new SchedulerException("Error loading Quartz properties file from classpath: org/quartz/quartz.properties", (Throwable)e);
            }
            String identity = this.getCamelContext().getName();
            String instName = prop.getProperty("org.quartz.scheduler.instanceName");
            instName = instName == null ? "scheduler-" + identity : instName + "-" + identity;
            prop.setProperty("org.quartz.scheduler.instanceName", instName);
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            answer = new StdSchedulerFactory(prop);
        }
        if (LOG.isDebugEnabled()) {
            String name = prop.getProperty("org.quartz.scheduler.instanceName");
            LOG.debug((Object)("Creating SchedulerFactory: " + name + " with properties: " + prop));
        }
        return answer;
    }

    protected Scheduler createScheduler() throws SchedulerException {
        Scheduler scheduler = this.getFactory().getScheduler();
        scheduler.getContext().put((Object)("CamelQuartzCamelContext-" + this.getCamelContext().getName()), (Object)this.getCamelContext());
        return scheduler;
    }

    private final class JobToAdd {
        private final JobDetail job;
        private final Trigger trigger;

        private JobToAdd(JobDetail job, Trigger trigger) {
            this.job = job;
            this.trigger = trigger;
        }

        public JobDetail getJob() {
            return this.job;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }
    }
}

