/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.ArrayList;
import java.util.List;
import quickfix.Field;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.SessionID;

public class MessagePredicate {
    private final List<Field<String>> headerCriteria = new ArrayList<Field<String>>();
    private final List<Field<String>> bodyCriteria = new ArrayList<Field<String>>();

    public MessagePredicate(SessionID requestingSessionID, String msgType) {
        this.addHeaderFieldIfPresent(49, requestingSessionID.getTargetCompID());
        this.addHeaderFieldIfPresent(56, requestingSessionID.getSenderCompID());
        this.withMessageType(msgType);
    }

    private void addHeaderFieldIfPresent(int tag, String value) {
        if (value != null && !"".equals(value)) {
            this.withHeaderField(tag, value);
        }
    }

    public boolean evaluate(Message message) {
        return this.evaluate((FieldMap)message, this.bodyCriteria) && this.evaluate((FieldMap)message.getHeader(), this.headerCriteria);
    }

    private boolean evaluate(FieldMap fieldMap, List<Field<String>> criteria) {
        for (Field<String> c : criteria) {
            String value = null;
            try {
                if (fieldMap.isSetField(c.getField())) {
                    value = fieldMap.getString(c.getField());
                }
            }
            catch (FieldNotFound e) {
                // empty catch block
            }
            if (((String)c.getObject()).equals(value)) continue;
            return false;
        }
        return true;
    }

    public MessagePredicate withField(int tag, String value) {
        this.bodyCriteria.add((Field<String>)new Field(tag, (Object)value));
        return this;
    }

    public MessagePredicate withHeaderField(int tag, String value) {
        this.headerCriteria.add((Field<String>)new Field(tag, (Object)value));
        return this;
    }

    private MessagePredicate withMessageType(String msgType) {
        this.headerCriteria.add((Field<String>)new Field(35, (Object)msgType));
        return this;
    }
}

