/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import org.apache.camel.Endpoint;
import org.apache.camel.component.quickfixj.QuickfixjEndpoint;
import org.apache.camel.component.quickfixj.QuickfixjEngine;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.SessionSettings;

public class QuickfixjComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjComponent.class);
    private final Object engineInstancesLock = new Object();
    private final Map<String, QuickfixjEngine> engines = new HashMap<String, QuickfixjEngine>();
    private final Map<String, QuickfixjEndpoint> endpoints = new HashMap<String, QuickfixjEndpoint>();
    private MessageStoreFactory messageStoreFactory;
    private LogFactory logFactory;
    private MessageFactory messageFactory;
    private boolean forcedShutdown;
    private Map<String, SessionSettings> engineSettings = new HashMap<String, SessionSettings>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Object object = this.engineInstancesLock;
        synchronized (object) {
            QuickfixjEndpoint endpoint = this.endpoints.get(uri);
            if (endpoint == null) {
                QuickfixjEngine engine = this.engines.get(remaining);
                if (engine == null) {
                    LOG.info("Creating QuickFIX/J engine using settings: " + remaining);
                    SessionSettings settings = this.engineSettings.get(remaining);
                    engine = settings != null ? new QuickfixjEngine(uri, settings, this.forcedShutdown, this.messageStoreFactory, this.logFactory, this.messageFactory) : new QuickfixjEngine(uri, remaining, this.forcedShutdown, this.messageStoreFactory, this.logFactory, this.messageFactory);
                    this.engines.put(remaining, engine);
                    if (this.isStarted()) {
                        this.startQuickfixjEngine(engine);
                    }
                }
                endpoint = new QuickfixjEndpoint(engine, uri, this.getCamelContext());
                engine.addEventListener(endpoint);
                this.endpoints.put(uri, endpoint);
            }
            return endpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("QuickFIX/J component started");
        Object object = this.engineInstancesLock;
        synchronized (object) {
            for (QuickfixjEngine engine : this.engines.values()) {
                this.startQuickfixjEngine(engine);
            }
        }
    }

    private void startQuickfixjEngine(QuickfixjEngine engine) throws Exception {
        LOG.info("Starting QuickFIX/J engine: uri=" + engine.getUri());
        engine.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        Object object = this.engineInstancesLock;
        synchronized (object) {
            for (QuickfixjEngine engine : this.engines.values()) {
                engine.stop();
            }
        }
        LOG.info("QuickFIX/J component stopped");
    }

    Map<String, QuickfixjEngine> getEngines() {
        return Collections.unmodifiableMap(this.engines);
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setLogFactory(LogFactory logFactory) {
        this.logFactory = logFactory;
    }

    public void setMessageStoreFactory(MessageStoreFactory messageStoreFactory) {
        this.messageStoreFactory = messageStoreFactory;
    }

    public void setForcedShutdown(boolean forcedShutdown) {
        this.forcedShutdown = forcedShutdown;
    }

    public void setEngineSettings(Map<String, SessionSettings> engineSettings) throws ConfigError, FieldConvertError, IOException, JMException, URISyntaxException {
        for (Map.Entry<String, SessionSettings> s : engineSettings.entrySet()) {
            this.engineSettings.put(QuickfixjComponent.getPath(s.getKey()), s.getValue());
        }
    }

    private static String getPath(String uri) throws URISyntaxException {
        int idx;
        URI u = new URI(UnsafeUriCharactersEncoder.encode((String)uri));
        String path = u.getSchemeSpecificPart();
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) > 0) {
            path = path.substring(0, idx);
        }
        return path;
    }
}

