/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.concurrent.Callable;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.quickfixj.MessageCorrelator;
import org.apache.camel.component.quickfixj.QuickfixjEndpoint;
import org.apache.camel.impl.DefaultProducer;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;

public class QuickfixjProducer
extends DefaultProducer {
    public static final String CORRELATION_TIMEOUT_KEY = "CorrelationTimeout";
    public static final String CORRELATION_CRITERIA_KEY = "CorrelationCriteria";
    private final SessionID sessionID = ((QuickfixjEndpoint)this.getEndpoint()).getSessionID();

    public QuickfixjProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        this.sendMessage(exchange, exchange.getIn());
    }

    void sendMessage(Exchange exchange, Message camelMessage) throws InterruptedException {
        try {
            Session session;
            quickfix.Message message = (quickfix.Message)camelMessage.getBody(quickfix.Message.class);
            this.log.debug("Sending FIX message: {}", (Object)message);
            SessionID messageSessionID = this.sessionID;
            if (messageSessionID == null) {
                messageSessionID = MessageUtils.getSessionID((quickfix.Message)message);
            }
            if ((session = this.getSession(messageSessionID)) == null) {
                throw new IllegalStateException("Unknown session: " + messageSessionID);
            }
            Callable<quickfix.Message> callable = null;
            if (exchange.getPattern().isOutCapable()) {
                QuickfixjEndpoint endpoint = (QuickfixjEndpoint)this.getEndpoint();
                MessageCorrelator messageCorrelator = endpoint.getEngine().getMessageCorrelator();
                callable = messageCorrelator.getReply(endpoint.getSessionID(), exchange);
            }
            session.send(message);
            if (callable != null) {
                quickfix.Message reply = (quickfix.Message)callable.call();
                exchange.getOut().setBody((Object)reply);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    Session getSession(SessionID messageSessionID) {
        return Session.lookupSession((SessionID)messageSessionID);
    }
}

