/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import quickfix.Dictionary;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class QuickfixjSettingsFactory
implements FactoryBean<SessionSettings> {
    private Map<Object, Object> defaultSettings = Collections.emptyMap();
    private Map<SessionID, Map<Object, Object>> sessionSettings = Collections.emptyMap();

    public SessionSettings getObject() throws Exception {
        SessionSettings settings = new SessionSettings();
        settings.set(new Dictionary("defaults", this.defaultSettings));
        for (Map.Entry<SessionID, Map<Object, Object>> sessionSetting : this.sessionSettings.entrySet()) {
            settings.set(sessionSetting.getKey(), new Dictionary("session", sessionSetting.getValue()));
        }
        return settings;
    }

    public Class<?> getObjectType() {
        return SessionSettings.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultSettings(Map<Object, Object> defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public void setSessionSettings(Map<SessionID, Map<Object, Object>> sessionSettings) {
        this.sessionSettings = sessionSettings;
    }
}

