/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj.converter;

import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.quickfixj.QuickfixjEventCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Session;
import quickfix.SessionID;

@Converter
public final class QuickfixjConverters {
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjConverters.class);

    private QuickfixjConverters() {
    }

    @Converter
    public static SessionID toSessionID(String sessionID) {
        return new SessionID(sessionID);
    }

    @Converter
    public static quickfix.Message toMessage(String value, Exchange exchange) throws InvalidMessage, ConfigError {
        DataDictionary dataDictionary = QuickfixjConverters.getDataDictionary(exchange);
        return new quickfix.Message(value, dataDictionary);
    }

    private static DataDictionary getDataDictionary(Exchange exchange) throws ConfigError {
        SessionID sessionID;
        Session session;
        Object dictionaryValue = exchange.getProperties().get("DataDictionary");
        DataDictionary dataDictionary = dictionaryValue instanceof DataDictionary ? (DataDictionary)dictionaryValue : (dictionaryValue instanceof String ? new DataDictionary((String)dictionaryValue) : ((session = Session.lookupSession((SessionID)(sessionID = (SessionID)exchange.getIn().getHeader("SessionID")))) != null ? session.getDataDictionary() : null));
        return dataDictionary;
    }

    public static Exchange toExchange(Endpoint endpoint, SessionID sessionID, quickfix.Message message, QuickfixjEventCategory eventCategory) {
        Exchange exchange = endpoint.createExchange(ExchangePattern.InOnly);
        Message camelMessage = exchange.getIn();
        camelMessage.setHeader("EventCategory", (Object)eventCategory);
        camelMessage.setHeader("SessionID", (Object)sessionID);
        if (message != null) {
            try {
                camelMessage.setHeader("MessageType", (Object)message.getHeader().getString(35));
            }
            catch (FieldNotFound fieldNotFoundEx) {
                LOG.error("Message type field not found in QFJ message, continuing...");
            }
        }
        camelMessage.setBody((Object)message);
        return exchange;
    }
}

