/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rest.resources;

import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.resource.Singleton;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.model.RoutesType;
import org.apache.camel.rest.model.Endpoints;
import org.apache.camel.rest.resources.EndpointResource;

@Path(value="/")
@Singleton
@Produces(value={"text/html", "application/xml", "application/json"})
public class CamelContextResource {
    private final CamelContext camelContext;

    public CamelContextResource(@Inject CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getName() {
        return this.camelContext.getName();
    }

    @GET
    @Path(value="endpoints")
    public Endpoints getEndpoint() {
        return new Endpoints(this.camelContext);
    }

    @GET
    @Path(value="endpoint/{id}")
    public EndpointResource getEndpoint(@PathParam(value="id") String id) {
        Endpoint endpoint = this.getCamelContext().getEndpoint(id);
        if (endpoint != null) {
            return new EndpointResource(endpoint);
        }
        return null;
    }

    @GET
    @Path(value="routes")
    public RoutesType getRouteDefinitions() {
        RoutesType answer = new RoutesType();
        if (this.camelContext != null) {
            List list = this.camelContext.getRouteDefinitions();
            answer.setRoutes(list);
        }
        return answer;
    }
}

