/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletComponent;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.restlet.data.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestletEndpoint
extends DefaultEndpoint {
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private Method restletMethod = Method.GET;
    private String protocol = "http";
    private String host = "localhost";
    private int port = 80;
    private String uriPattern;
    private RestletBinding restletBinding;
    private Map<String, String> realm;

    public RestletEndpoint(RestletComponent component, String remaining, RestletBinding restletBinding) throws Exception {
        super(remaining, (Component)component);
        this.restletBinding = restletBinding;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new RestletConsumer((Endpoint)this, processor);
    }

    public Producer createProducer() throws Exception {
        return new RestletProducer(this);
    }

    public void connect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).connect(restletConsumer);
    }

    public void disconnect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).disconnect(restletConsumer);
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    public void setRestletMethod(Method restletMethod) {
        this.restletMethod = restletMethod;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public RestletBinding getRestletBinding() {
        return this.restletBinding;
    }

    public void setRestletBinding(RestletBinding restletBinding) {
        this.restletBinding = restletBinding;
    }

    public Map<String, String> getRealm() {
        return this.realm;
    }

    public void setRealm(Map<String, String> realm) {
        this.realm = realm;
    }
}

