/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.HeaderFilterStrategyAware;
import org.apache.camel.component.restlet.DefaultRestletBinding;
import org.apache.camel.component.restlet.MethodBasedRouter;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.component.restlet.RestletHeaderFilterStrategy;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Component;
import org.restlet.Guard;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestletComponent
extends DefaultComponent<Exchange>
implements HeaderFilterStrategyAware {
    private static final Log LOG = LogFactory.getLog(RestletComponent.class);
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Map<String, MethodBasedRouter> routers = new HashMap<String, MethodBasedRouter>();
    private final Component component = new Component();
    private HeaderFilterStrategy headerFilterStrategy = new RestletHeaderFilterStrategy();

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        RestletBinding restletBinding = null;
        String ref = (String)this.getAndRemoveParameter(parameters, "restletBindingRef", String.class);
        if (ref != null) {
            restletBinding = (RestletBinding)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)ref, RestletBinding.class);
        }
        if (restletBinding == null) {
            restletBinding = new DefaultRestletBinding();
        }
        if (restletBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)restletBinding).setHeaderFilterStrategy(this.headerFilterStrategy);
        }
        Map realm = null;
        ref = (String)this.getAndRemoveParameter(parameters, "restletRealmRef", String.class);
        if (ref != null) {
            realm = (Map)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)ref, Map.class);
        }
        Method method = (Method)this.getAndRemoveParameter(parameters, "restletMethod", Method.class);
        URI u = new URI(UnsafeUriCharactersEncoder.encode((String)remaining));
        String protocol = u.getScheme();
        String uriPattern = u.getPath();
        if (parameters.size() > 0) {
            uriPattern = uriPattern + "?" + URISupport.createQueryString((Map)parameters);
        }
        int port = 0;
        String host = u.getHost();
        if (u.getPort() > 0) {
            port = u.getPort();
        }
        RestletEndpoint result = new RestletEndpoint(this, remaining, restletBinding);
        result.setProtocol(protocol);
        result.setUriPattern(uriPattern);
        result.setHost(host);
        if (port > 0) {
            result.setPort(port);
        }
        if (method != null) {
            result.setRestletMethod(method);
        }
        if (realm != null) {
            result.setRealm(realm);
        }
        return result;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.component.start();
    }

    protected void doStop() throws Exception {
        this.component.stop();
        this.servers.clear();
        this.routers.clear();
        super.doStop();
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public void connect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = (RestletEndpoint)consumer.getEndpoint();
        this.addServerIfNeccessary(endpoint);
        MethodBasedRouter router = this.getMethodRouter(endpoint.getUriPattern());
        Map<String, String> realm = endpoint.getRealm();
        Restlet target = consumer.getRestlet();
        if (realm != null && realm.size() > 0) {
            Guard guard = new Guard(this.component.getContext().createChildContext(), ChallengeScheme.HTTP_BASIC, "Camel-Restlet Endpoint Realm");
            for (Map.Entry<String, String> entry : realm.entrySet()) {
                guard.getSecrets().put(entry.getKey(), entry.getValue().toCharArray());
            }
            guard.setNext(target);
            target = guard;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Target has been set to guard: " + guard));
            }
        }
        router.addRoute(endpoint.getRestletMethod(), target);
        if (!router.hasBeenAttached()) {
            this.component.getDefaultHost().attach(endpoint.getUriPattern(), (Restlet)router);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attached methodRouter uriPattern: " + endpoint.getUriPattern()));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attached restlet uriPattern: " + endpoint.getUriPattern() + " method: " + endpoint.getRestletMethod()));
        }
    }

    public void disconnect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = (RestletEndpoint)consumer.getEndpoint();
        MethodBasedRouter router = this.getMethodRouter(endpoint.getUriPattern());
        router.removeRoute(endpoint.getRestletMethod());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Detached restlet uriPattern: " + endpoint.getUriPattern() + " method: " + endpoint.getRestletMethod()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodBasedRouter getMethodRouter(String uriPattern) {
        Map<String, MethodBasedRouter> map = this.routers;
        synchronized (map) {
            MethodBasedRouter result = this.routers.get(uriPattern);
            if (result == null) {
                result = new MethodBasedRouter(uriPattern);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added method based router: " + (Object)((Object)result)));
                }
                this.routers.put(uriPattern, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerIfNeccessary(RestletEndpoint endpoint) throws Exception {
        String key = RestletComponent.buildKey(endpoint);
        Map<String, Server> map = this.servers;
        synchronized (map) {
            Server server = this.servers.get(key);
            if (server == null) {
                server = this.component.getServers().add(Protocol.valueOf((String)endpoint.getProtocol()), endpoint.getPort());
                this.servers.put(key, server);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added server: " + key));
                }
                server.start();
            }
        }
    }

    private static String buildKey(RestletEndpoint endpoint) {
        return endpoint.getHost() + ":" + endpoint.getPort();
    }
}

