/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

class MethodBasedRouter
extends Restlet {
    private static final Log LOG = LogFactory.getLog(MethodBasedRouter.class);
    private String uriPattern;
    private Map<Method, Restlet> routes = new ConcurrentHashMap<Method, Restlet>();
    private AtomicBoolean hasBeenAttachedFlag = new AtomicBoolean(false);

    MethodBasedRouter(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public void handle(Request request, Response response) {
        Restlet target;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MethodRouter (" + this.uriPattern + ") received request method: " + request.getMethod()));
        }
        if ((target = this.routes.get(request.getMethod())) != null) {
            target.handle(request, response);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No route for request method: " + request.getMethod()));
            }
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    void addRoute(Method method, Restlet target) {
        this.routes.put(method, target);
    }

    void removeRoute(Method method) {
        this.routes.remove(method);
    }

    boolean hasBeenAttached() {
        return this.hasBeenAttachedFlag.getAndSet(true);
    }
}

