/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletComponent;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.restlet.data.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestletEndpoint
extends DefaultEndpoint {
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private Method restletMethod = Method.GET;
    private String protocol = "http";
    private String host = "localhost";
    private int port = 80;
    private String uriPattern;
    private RestletBinding restletBinding;
    private Map<String, String> realm;

    public RestletEndpoint(RestletComponent component, String remaining, Map<String, String> parameters, RestletBinding restletBinding) throws Exception {
        super(remaining, (Component)component);
        this.restletBinding = restletBinding;
        URI u = new URI(UnsafeUriCharactersEncoder.encode((String)remaining));
        this.protocol = u.getScheme();
        this.uriPattern = u.getPath();
        if (parameters.size() > 0) {
            this.uriPattern = this.uriPattern + "?" + URISupport.createQueryString(parameters);
        }
        this.host = u.getHost();
        if (u.getPort() > 0) {
            this.port = u.getPort();
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new RestletConsumer((Endpoint)this, processor);
    }

    public Producer createProducer() throws Exception {
        return new RestletProducer(this);
    }

    public void connect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).connect(restletConsumer);
    }

    public void disconnect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).disconnect(restletConsumer);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public RestletBinding getRestletBinding() {
        return this.restletBinding;
    }

    public void setRestletMethod(Method restletMethod) {
        this.restletMethod = restletMethod;
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    public void setRealm(Map<String, String> realm) {
        this.realm = realm;
    }

    public Map<String, String> getRealm() {
        return this.realm;
    }
}

