/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.restlet.MethodBasedRouter;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Component;
import org.restlet.Guard;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;

public class RestletComponent
extends HeaderFilterStrategyComponent {
    private static final Log LOG = LogFactory.getLog(RestletComponent.class);
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Map<String, MethodBasedRouter> routers = new HashMap<String, MethodBasedRouter>();
    private final Component component = new Component();

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        RestletEndpoint result = new RestletEndpoint(this, remaining);
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties((Object)result, parameters);
        URI u = new URI(UnsafeUriCharactersEncoder.encode((String)remaining));
        String protocol = u.getScheme();
        String uriPattern = u.getPath();
        if (parameters.size() > 0) {
            uriPattern = uriPattern + "?" + URISupport.createQueryString((Map)parameters);
        }
        int port = 0;
        String host = u.getHost();
        if (u.getPort() > 0) {
            port = u.getPort();
        }
        result.setProtocol(protocol);
        result.setUriPattern(uriPattern);
        result.setHost(host);
        if (port > 0) {
            result.setPort(port);
        }
        return result;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.component.start();
    }

    protected void doStop() throws Exception {
        this.component.stop();
        super.doStop();
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public void connect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = (RestletEndpoint)consumer.getEndpoint();
        this.addServerIfNecessary(endpoint);
        if (endpoint.getUriPattern() != null && endpoint.getUriPattern().length() > 0) {
            this.attachUriPatternToRestlet(endpoint.getUriPattern(), endpoint, consumer.getRestlet());
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                this.attachUriPatternToRestlet(uriPattern, endpoint, consumer.getRestlet());
            }
        }
    }

    public void disconnect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = (RestletEndpoint)consumer.getEndpoint();
        ArrayList<MethodBasedRouter> routers = new ArrayList<MethodBasedRouter>();
        if (endpoint.getUriPattern() != null && endpoint.getUriPattern().length() > 0) {
            routers.add(this.getMethodRouter(endpoint.getUriPattern()));
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                routers.add(this.getMethodRouter(uriPattern));
            }
        }
        for (MethodBasedRouter router : routers) {
            if (endpoint.getRestletMethods() != null) {
                Method[] methods;
                for (Method method : methods = endpoint.getRestletMethods()) {
                    router.removeRoute(method);
                }
            } else {
                router.removeRoute(endpoint.getRestletMethod());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Detached restlet uriPattern: " + router.getUriPattern() + " method: " + endpoint.getRestletMethod()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodBasedRouter getMethodRouter(String uriPattern) {
        Map<String, MethodBasedRouter> map = this.routers;
        synchronized (map) {
            MethodBasedRouter result = this.routers.get(uriPattern);
            if (result == null) {
                result = new MethodBasedRouter(uriPattern);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added method based router: " + (Object)((Object)result)));
                }
                this.routers.put(uriPattern, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerIfNecessary(RestletEndpoint endpoint) throws Exception {
        String key = RestletComponent.buildKey(endpoint);
        Map<String, Server> map = this.servers;
        synchronized (map) {
            Server server = this.servers.get(key);
            if (server == null) {
                server = this.component.getServers().add(Protocol.valueOf((String)endpoint.getProtocol()), endpoint.getPort());
                this.servers.put(key, server);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added server: " + key));
                }
                server.start();
            }
        }
    }

    private static String buildKey(RestletEndpoint endpoint) {
        return endpoint.getHost() + ":" + endpoint.getPort();
    }

    private void attachUriPatternToRestlet(String uriPattern, RestletEndpoint endpoint, Restlet target) {
        MethodBasedRouter router = this.getMethodRouter(uriPattern);
        Map<String, String> realm = endpoint.getRestletRealm();
        if (realm != null && realm.size() > 0) {
            Guard guard = new Guard(this.component.getContext().createChildContext(), ChallengeScheme.HTTP_BASIC, "Camel-Restlet Endpoint Realm");
            for (Map.Entry<String, String> entry : realm.entrySet()) {
                guard.getSecrets().put(entry.getKey(), entry.getValue().toCharArray());
            }
            guard.setNext(target);
            target = guard;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Target has been set to guard: " + guard));
            }
        }
        if (endpoint.getRestletMethods() != null) {
            Method[] methods;
            for (Method method : methods = endpoint.getRestletMethods()) {
                router.addRoute(method, target);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Attached restlet uriPattern: " + uriPattern + " method: " + method));
            }
        } else {
            router.addRoute(endpoint.getRestletMethod(), target);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attached restlet uriPattern: " + uriPattern + " method: " + endpoint.getRestletMethod()));
            }
        }
        if (!router.hasBeenAttached()) {
            this.component.getDefaultHost().attach(uriPattern, (Restlet)router);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attached methodRouter uriPattern: " + uriPattern));
            }
        }
    }
}

