/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.component.restlet.RestletOperationException;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestletProducer
extends DefaultProducer {
    private static final Log LOG = LogFactory.getLog(RestletProducer.class);
    private static final Pattern PATTERN = Pattern.compile("\\{([\\w\\.]*)\\}");
    private Client client;
    private boolean throwException;

    public RestletProducer(RestletEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.client = new Client(endpoint.getProtocol());
        this.client.setContext(new Context());
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client.start();
    }

    public void doStop() throws Exception {
        this.client.stop();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        Integer respCode;
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        String resourceUri = RestletProducer.buildUri(endpoint, exchange);
        Request request = new Request(endpoint.getRestletMethod(), resourceUri);
        RestletBinding binding = endpoint.getRestletBinding();
        binding.populateRestletRequestFromExchange(request, exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Client sends a request (method: " + request.getMethod() + ", uri: " + resourceUri + ")"));
        }
        Response response = this.client.handle(request);
        if (this.throwException && response instanceof Response && (respCode = Integer.valueOf(response.getStatus().getCode())) > 207) {
            throw this.populateRestletProducerException(exchange, response, respCode);
        }
        binding.populateExchangeFromRestletResponse(exchange, response);
    }

    private static String buildUri(RestletEndpoint endpoint, Exchange exchange) throws CamelExchangeException {
        String uri = endpoint.getProtocol() + "://" + endpoint.getHost() + ":" + endpoint.getPort() + endpoint.getUriPattern();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Substituting { } placeholders in uri: " + uri));
        }
        Matcher matcher = PATTERN.matcher(uri);
        while (matcher.find()) {
            String key = matcher.group(1);
            String header = (String)exchange.getIn().getHeader(key, String.class);
            if (header == null) {
                throw new CamelExchangeException("Header with key: " + key + " not found in Exchange", exchange);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Replacing: " + matcher.group(0) + " with header value: " + header));
            }
            uri = matcher.replaceFirst(header);
            matcher.reset(uri);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using uri: " + uri));
        }
        return uri;
    }

    protected RestletOperationException populateRestletProducerException(Exchange exchange, Response response, int responseCode) {
        RestletOperationException exception;
        String uri = exchange.getFromEndpoint().getEndpointUri();
        String statusText = response.getStatus().getDescription();
        Map<String, String> headers = this.parseResponseHeaders(response, exchange);
        String copy = response.toString();
        LOG.warn(headers);
        if (responseCode >= 300 && responseCode < 400) {
            if (response.getStatus().isRedirection()) {
                String redirectLocation = response.getLocationRef().getHostIdentifier();
                exception = new RestletOperationException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    protected Map<String, String> parseResponseHeaders(Object response, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getAttributes().entrySet()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Parse external header " + (String)entry.getKey() + "=" + entry.getValue()));
                }
                LOG.info((Object)("Parse external header " + (String)entry.getKey() + "=" + entry.getValue()));
                answer.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return answer;
    }
}

