/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.component.restlet.RestletOperationException;
import org.apache.camel.impl.DefaultProducer;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(RestletProducer.class);
    private static final Pattern PATTERN = Pattern.compile("\\{([\\w\\.]*)\\}");
    private Client client;
    private boolean throwException;

    public RestletProducer(RestletEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.client = new Client(endpoint.getProtocol());
        this.client.setContext(new Context());
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client.start();
    }

    public void doStop() throws Exception {
        this.client.stop();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        Integer respCode;
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        String resourceUri = RestletProducer.buildUri(endpoint, exchange);
        Request request = new Request(endpoint.getRestletMethod(), resourceUri);
        RestletBinding binding = endpoint.getRestletBinding();
        binding.populateRestletRequestFromExchange(request, exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Client sends a request (method: " + request.getMethod() + ", uri: " + resourceUri + ")");
        }
        Response response = this.client.handle(request);
        if (this.throwException && response != null && (respCode = Integer.valueOf(response.getStatus().getCode())) > 207) {
            throw this.populateRestletProducerException(exchange, response, respCode);
        }
        binding.populateExchangeFromRestletResponse(exchange, response);
    }

    private static String buildUri(RestletEndpoint endpoint, Exchange exchange) throws CamelExchangeException {
        String uri = endpoint.getProtocol() + "://" + endpoint.getHost() + ":" + endpoint.getPort() + endpoint.getUriPattern();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Substituting { } placeholders in uri: " + uri);
        }
        Matcher matcher = PATTERN.matcher(uri);
        while (matcher.find()) {
            String key = matcher.group(1);
            String header = (String)exchange.getIn().getHeader(key, String.class);
            if (header == null) {
                throw new CamelExchangeException("Header with key: " + key + " not found in Exchange", exchange);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Replacing: " + matcher.group(0) + " with header value: " + header);
            }
            uri = matcher.replaceFirst(header);
            matcher.reset(uri);
        }
        String query = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (query != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Adding query: " + query + " to uri: " + uri);
            }
            uri = RestletProducer.addQueryToUri(uri, query);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using uri: " + uri);
        }
        return uri;
    }

    protected static String addQueryToUri(String uri, String query) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        StringBuffer answer = new StringBuffer();
        int index = uri.indexOf(63);
        if (index < 0) {
            answer.append(uri);
            answer.append("?");
            answer.append(query);
        } else {
            answer.append(uri.substring(0, index));
            answer.append("?");
            answer.append(query);
            String remaining = uri.substring(index + 1);
            if (remaining.length() > 0) {
                answer.append("&");
                answer.append(remaining);
            }
        }
        return answer.toString();
    }

    protected RestletOperationException populateRestletProducerException(Exchange exchange, Response response, int responseCode) {
        RestletOperationException exception;
        String uri = exchange.getFromEndpoint().getEndpointUri();
        String statusText = response.getStatus().getDescription();
        Map<String, String> headers = this.parseResponseHeaders(response, exchange);
        String copy = response.toString();
        if (responseCode >= 300 && responseCode < 400) {
            if (response.getStatus().isRedirection()) {
                String redirectLocation = response.getLocationRef().getHostIdentifier();
                exception = new RestletOperationException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    protected Map<String, String> parseResponseHeaders(Object response, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getAttributes().entrySet()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Parse external header " + (String)entry.getKey() + "=" + entry.getValue());
                }
                answer.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return answer;
    }
}

