/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import java.util.Arrays;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.feed.FeedPollingConsumer;
import org.apache.camel.component.rss.RssEntryPollingConsumer;
import org.apache.camel.component.rss.RssPollingConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RssEndpoint
extends FeedEndpoint {
    protected static final transient Log LOG = LogFactory.getLog(RssEndpoint.class);

    public RssEndpoint() {
    }

    public RssEndpoint(String endpointUri, FeedComponent component, String feedUri) {
        super(endpointUri, component, feedUri);
    }

    public RssEndpoint(String endpointUri, String feedUri) {
        super(endpointUri, feedUri);
    }

    public RssEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Exchange createExchange(Object feed) {
        Exchange exchange = this.createExchangeWithFeedHeader(feed, "CamelRssFeed");
        exchange.getIn().setBody(feed);
        return exchange;
    }

    public Exchange createExchange(Object feed, Object entry) {
        SyndFeed newFeed;
        Exchange exchange = this.createExchangeWithFeedHeader(feed, "CamelRssFeed");
        try {
            newFeed = (SyndFeed)((SyndFeed)feed).clone();
            newFeed.setEntries(Arrays.asList(entry));
        }
        catch (CloneNotSupportedException e) {
            LOG.debug((Object)"Could not create a new feed.", (Throwable)e);
            newFeed = null;
        }
        exchange.getIn().setBody((Object)newFeed);
        return exchange;
    }

    protected FeedPollingConsumer createEntryPollingConsumer(FeedEndpoint feedEndpoint, Processor processor, boolean filter, Date lastUpdate) {
        return new RssEntryPollingConsumer(this, processor, filter, lastUpdate);
    }

    protected FeedPollingConsumer createPollingConsumer(FeedEndpoint feedEndpoint, Processor processor) {
        return new RssPollingConsumer(this, processor);
    }
}

