/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.ruby;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptRouteBuilder
extends RouteBuilder {
    private static final transient Logger LOG = LoggerFactory.getLogger(ScriptRouteBuilder.class);
    protected ProcessorDefinition node;

    public ScriptRouteBuilder() {
    }

    public ScriptRouteBuilder(CamelContext context) {
        super(context);
    }

    protected void configureRoute(RouteDefinition route) {
        super.configureRoute(route);
        this.node = route;
    }

    public ProcessorDefinition to(String uri) {
        return this.getNode().to(uri);
    }

    public ProcessorDefinition to(Endpoint endpoint) {
        return this.getNode().to(endpoint);
    }

    public ProcessorDefinition getNode() {
        if (this.node == null) {
            throw new IllegalStateException("You must define a route first via the from() method");
        }
        return this.node;
    }

    public void setNode(ProcessorDefinition node) {
        this.node = node;
        LOG.info("Node is now: " + node);
    }
}

