/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.processor.SalesforceProcessor;
import org.eclipse.jetty.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSalesforceProcessor
implements SalesforceProcessor {
    protected static final boolean NOT_OPTIONAL = false;
    protected static final boolean IS_OPTIONAL = true;
    protected static final boolean USE_BODY = true;
    protected static final boolean IGNORE_BODY = false;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SalesforceEndpoint endpoint;
    protected final Map<String, String> endpointConfigMap;
    protected final OperationName operationName;
    protected final SalesforceSession session;
    protected final HttpClient httpClient;

    public AbstractSalesforceProcessor(SalesforceEndpoint endpoint) {
        this.endpoint = endpoint;
        this.operationName = endpoint.getOperationName();
        this.endpointConfigMap = endpoint.getConfiguration().toValueMap();
        SalesforceComponent component = endpoint.getComponent();
        this.session = component.getSession();
        this.httpClient = endpoint.getConfiguration().getHttpClient();
    }

    @Override
    public abstract boolean process(Exchange var1, AsyncCallback var2);

    protected final String getParameter(String propName, Exchange exchange, boolean convertInBody, boolean optional) throws SalesforceException {
        String propValue = (String)exchange.getIn().getHeader(propName, String.class);
        propValue = propValue == null ? this.endpointConfigMap.get(propName) : propValue;
        String string = propValue = propValue == null && convertInBody ? (String)exchange.getIn().getBody(String.class) : propValue;
        if (propValue == null && !optional) {
            String msg = "Missing property " + propName;
            throw new SalesforceException(msg, null);
        }
        return propValue;
    }
}

